/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.xml.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.goplanit.xml.utils.PlanitNamespacePrefixMapper;

public class JAXBUtils {
    public static final Logger LOGGER = Logger.getLogger(JAXBUtils.class.getCanonicalName());

    public static void validateXml(File xmlFileLocation, String schemaFileLocation) throws Exception {
        LOGGER.fine("validating " + xmlFileLocation.getAbsolutePath() + " against " + schemaFileLocation);
        String schemaLang = "http://www.w3.org/2001/XMLSchema";
        SchemaFactory factory = SchemaFactory.newInstance(schemaLang);
        Schema schema = factory.newSchema(new StreamSource(schemaFileLocation));
        Validator validator = schema.newValidator();
        validator.validate(new StreamSource(xmlFileLocation));
    }

    public static Object generateObjectFromXml(Class<?> clazz, File xmlFileLocation) throws Exception {
        FileReader fileReader = new FileReader(xmlFileLocation);
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(fileReader);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        Object obj = unmarshaller.unmarshal(xmlStreamReader);
        xmlStreamReader.close();
        fileReader.close();
        return obj;
    }

    public static void generateXmlFileFromObject(Object object, Class<?> clazz, Path xmlFileLocation, String noNameSpaceUri) throws Exception {
        if (!clazz.isInstance(object)) {
            throw new RuntimeException("Trying to convert an object to XML which is not of class " + clazz.getName());
        }
        FileOutputStream outputStream = new FileOutputStream(xmlFileLocation.toFile());
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Marshaller marshaller = jaxbContext.createMarshaller();
            JAXBUtils.setPlanitNamespacePrefixes(marshaller);
            if (noNameSpaceUri != null && !noNameSpaceUri.isBlank()) {
                marshaller.setProperty("jaxb.noNamespaceSchemaLocation", (Object)noNameSpaceUri);
            }
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(object, (OutputStream)outputStream);
        }
        catch (Exception e) {
            ((OutputStream)outputStream).close();
            throw e;
        }
        ((OutputStream)outputStream).close();
    }

    public static void setPlanitNamespacePrefixes(Marshaller marshaller) throws PropertyException {
        PlanitNamespacePrefixMapper mapper = new PlanitNamespacePrefixMapper();
        try {
            marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)mapper);
        }
        catch (Exception e) {
            marshaller.setProperty("com.sun.xml.internal.bind.namespacePrefixMapper", (Object)mapper);
        }
    }

    public static <T> T generateInstanceFromXml(Class<T> clazz, File[] potentialXmlFileNames) {
        T result = null;
        for (int i = 0; i < potentialXmlFileNames.length; ++i) {
            File currFileName = potentialXmlFileNames[i];
            if (result != null) continue;
            try {
                Object parsedXmlContent = JAXBUtils.generateObjectFromXml(clazz, currFileName);
                result = clazz.cast(parsedXmlContent);
                LOGGER.info("parsed file " + currFileName);
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }
}

