/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.xml.bindings;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class TimeAdapter
extends XmlAdapter<String, LocalTime> {
    public LocalTime unmarshal(String v) {
        if (Objects.nonNull(v)) {
            try {
                return LocalTime.parse(v);
            }
            catch (DateTimeParseException e) {
                throw new RuntimeException("Failed to parse time: " + v, e);
            }
        }
        return null;
    }

    public String marshal(LocalTime v) {
        if (Objects.nonNull(v)) {
            return v.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
        }
        return null;
    }
}

