/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.zoning;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Function;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;

public class TransferZoneGroupUtils {
    public static <G extends TransferZoneGroup, Z extends TransferZone> void updateTransferZoneMapping(Iterable<G> transferZoneGroups, Function<Z, Z> zoneToZoneMapping, boolean removeMissingMappings) {
        for (TransferZoneGroup tzGroup : transferZoneGroups) {
            if (!tzGroup.hasTransferZones()) continue;
            ArrayList<TransferZone> transferZonesToAdd = new ArrayList<TransferZone>(tzGroup.getTransferZones().size());
            Iterator<TransferZone> tzGroupIter = tzGroup.getTransferZones().iterator();
            while (tzGroupIter.hasNext()) {
                TransferZone currAccessZone = tzGroupIter.next();
                TransferZone newAccessZone = (TransferZone)zoneToZoneMapping.apply(currAccessZone);
                if (newAccessZone == null && !removeMissingMappings) continue;
                tzGroupIter.remove();
                if (newAccessZone == null) continue;
                transferZonesToAdd.add(newAccessZone);
            }
            tzGroup.addAllTransferZones(transferZonesToAdd);
        }
    }
}

