/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.zoning;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Logger;
import org.goplanit.utils.misc.IterableUtils;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.physical.UntypedPhysicalLayer;
import org.goplanit.utils.zoning.Connectoids;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.DirectedConnectoidFactory;

public interface DirectedConnectoids
extends Connectoids<DirectedConnectoid> {
    public static final Logger LOGGER = Logger.getLogger(DirectedConnectoids.class.getCanonicalName());

    public DirectedConnectoidFactory getFactory();

    @Override
    public DirectedConnectoids shallowClone();

    @Override
    public DirectedConnectoids deepClone();

    public DirectedConnectoids deepCloneWithMapping(BiConsumer<DirectedConnectoid, DirectedConnectoid> var1);

    default public <L extends UntypedPhysicalLayer<?, ?, ?>, K extends Comparable> Map<L, Map<K, List<DirectedConnectoid>>> groupByPhysicalLayerAndCustomKey(Iterable<L> networkLayers, Function<DirectedConnectoid, K> mapToKey) {
        HashMap directedConnectoidsByLocation = new HashMap();
        for (DirectedConnectoid dirConnectoid : this) {
            LinkSegment accessLinkSegment = dirConnectoid.getAccessLinkSegment();
            Optional<UntypedPhysicalLayer> layerOption = IterableUtils.asStream(networkLayers).filter(l -> l.getLinkSegments().get(accessLinkSegment.getId()) != null).findFirst();
            if (!layerOption.isPresent()) continue;
            directedConnectoidsByLocation.putIfAbsent(layerOption.get(), new HashMap());
            Map layerConnectoids = (Map)directedConnectoidsByLocation.get(layerOption.get());
            layerConnectoids.putIfAbsent((Comparable)mapToKey.apply(dirConnectoid), new ArrayList(1));
            ((List)layerConnectoids.get(mapToKey.apply(dirConnectoid))).add(dirConnectoid);
        }
        return directedConnectoidsByLocation;
    }
}

