/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.zoning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLink;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.zoning.Connectoid;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.Zone;
import org.locationtech.jts.geom.Point;

public class ConnectoidUtils {
    private static final Logger LOGGER = Logger.getLogger(ConnectoidUtils.class.getCanonicalName());

    public static Collection<DirectedConnectoid> findDirectedConnectoidsReferencingLink(Link link, Map<Point, List<DirectedConnectoid>> connectoidsByLocation) {
        HashSet<DirectedConnectoid> referencingConnectoids = new HashSet<DirectedConnectoid>();
        HashSet<Point> eligibleLocations = new HashSet<Point>();
        if (link.hasEdgeSegmentAb()) {
            eligibleLocations.add(link.getEdgeSegmentAb().getDownstreamVertex().getPosition());
        }
        if (link.hasEdgeSegmentBa()) {
            eligibleLocations.add(link.getEdgeSegmentBa().getDownstreamVertex().getPosition());
        }
        for (Point location : eligibleLocations) {
            Collection knownConnectoidsForLink = connectoidsByLocation.get(location);
            if (knownConnectoidsForLink == null || knownConnectoidsForLink.isEmpty()) continue;
            for (DirectedConnectoid connectoid : knownConnectoidsForLink) {
                if (!connectoid.getAccessLinkSegment().idEquals(link.getEdgeSegmentAb()) && !connectoid.getAccessLinkSegment().idEquals(link.getEdgeSegmentBa())) continue;
                referencingConnectoids.add(connectoid);
            }
        }
        return referencingConnectoids;
    }

    public static Map<Point, DirectedConnectoid> findDirectedConnectoidsReferencingLinks(Collection<MacroscopicLink> links, Map<Point, List<DirectedConnectoid>> connectoidsByLocation) {
        HashMap<Point, DirectedConnectoid> connectoidEligibleAccessNodesLocations = new HashMap<Point, DirectedConnectoid>();
        for (Link link : links) {
            Collection<DirectedConnectoid> connectoids = ConnectoidUtils.findDirectedConnectoidsReferencingLink(link, connectoidsByLocation);
            if (connectoids == null || connectoids.isEmpty()) continue;
            connectoids.forEach(connectoid -> connectoidEligibleAccessNodesLocations.put(connectoid.getAccessNode().getPosition(), (DirectedConnectoid)connectoid));
        }
        return connectoidEligibleAccessNodesLocations;
    }

    public static <C extends Connectoid, Z extends Zone> void updateAccessZoneMapping(Iterable<C> connectoids, Function<Z, Z> zoneToZoneMapping, boolean removeMissingMappings) {
        for (Connectoid connectoid : connectoids) {
            if (!connectoid.hasAccessZones()) continue;
            ArrayList<Zone> accessZonesToAdd = new ArrayList<Zone>(connectoid.getNumberOfAccessZones());
            Iterator<Zone> accessZoneIter = connectoid.getAccessZones().iterator();
            while (accessZoneIter.hasNext()) {
                Zone currAccessZone = accessZoneIter.next();
                Zone newAccessZone = (Zone)zoneToZoneMapping.apply(currAccessZone);
                if (newAccessZone == null && !removeMissingMappings) continue;
                accessZoneIter.remove();
                if (newAccessZone == null) continue;
                accessZonesToAdd.add(newAccessZone);
            }
            connectoid.addAllAccessZones(accessZonesToAdd);
        }
    }
}

