/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.zoning;

import java.util.Collection;
import java.util.Optional;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.id.ManagedId;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.zoning.ConnectoidType;
import org.goplanit.utils.zoning.Zone;

public interface Connectoid
extends ExternalIdAble,
ManagedId,
Iterable<Zone> {
    public static final Class<Connectoid> CONNECTOID_ID_CLASS = Connectoid.class;
    public static final double DEFAULT_LENGTH_KM = 0.0;
    public static final ConnectoidType DEFAULT_CONNECTOID_TYPE = ConnectoidType.NONE;

    public void setName(String var1);

    public String getName();

    public void setType(ConnectoidType var1);

    public ConnectoidType getType();

    public Collection<Zone> getAccessZones();

    public void setLength(Zone var1, double var2);

    public void addAllowedMode(Zone var1, Mode var2);

    public Zone addAccessZone(Zone var1);

    default public void addAllAccessZones(Collection<Zone> accessZonesToAdd) {
        accessZonesToAdd.forEach(z -> this.addAccessZone((Zone)z));
    }

    public boolean hasAccessZone(Zone var1);

    public Zone getFirstAccessZone();

    public int getNumberOfAccessZones();

    public Optional<Double> getLengthKm(Zone var1);

    public boolean isModeAllowed(Zone var1, Mode var2);

    public Collection<Mode> getExplicitlyAllowedModes(Zone var1);

    public DirectedVertex getAccessVertex();

    default public Class<Connectoid> getIdClass() {
        return CONNECTOID_ID_CLASS;
    }

    default public boolean hasName() {
        return this.getName() != null && !this.getName().isBlank();
    }

    default public void addAllowedModes(Zone zone, Mode ... allowedModes) {
        for (int index = 0; index < allowedModes.length; ++index) {
            this.addAllowedMode(zone, allowedModes[index]);
        }
    }

    default public void addAllowedModes(Zone transferZone, Collection<Mode> allowedModes) {
        allowedModes.forEach(mode -> this.addAllowedMode(transferZone, (Mode)mode));
    }

    default public boolean hasExplicitlyAllowedModes(Zone accessZone) {
        Collection<Mode> allowedModes = this.getExplicitlyAllowedModes(accessZone);
        return allowedModes != null && !allowedModes.isEmpty();
    }

    default public boolean isAllModesAllowed(Zone accessZone) {
        return !this.hasExplicitlyAllowedModes(accessZone);
    }

    default public boolean hasLength(Zone accessZone) {
        try {
            return this.getLengthKm(accessZone).isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    default public boolean hasAccessZones() {
        return this.getNumberOfAccessZones() > 0;
    }

    @Override
    public Connectoid shallowClone();

    @Override
    public Connectoid deepClone();
}

