/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.zip;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.goplanit.utils.misc.FileUtils;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.misc.UrlUtils;
import org.goplanit.utils.zip.PlanitZipFileInputStream;
import org.goplanit.utils.zip.PlanitZipInputStream;

public class ZipUtils {
    private static final Logger LOGGER = Logger.getLogger(ZipUtils.class.getCanonicalName());

    public static PlanitZipInputStream createZipInputStream(URL zipFileLocation) throws FileNotFoundException, URISyntaxException {
        if (!UrlUtils.isLocalZipFile(zipFileLocation)) {
            return null;
        }
        FileInputStream fis = new FileInputStream(new File(zipFileLocation.toURI()));
        BufferedInputStream bis = new BufferedInputStream(fis);
        PlanitZipInputStream zipStream = PlanitZipInputStream.of(bis, fis);
        return zipStream;
    }

    public static ZipFile createZipFile(URL zipUrl) throws ZipException, IOException {
        return new ZipFile(FileUtils.create(zipUrl));
    }

    public static PlanitZipInputStream createZipEntryInputStream(URL zipFileLocation, String zipEntryFileName, boolean logInfo) throws URISyntaxException, IOException {
        File file = UrlUtils.asLocalPath(zipFileLocation).toAbsolutePath().toFile();
        if (logInfo) {
            LOGGER.info(String.format("[LOG INFO] Zip File exists: %s", file.exists()));
        }
        if (file.exists() && logInfo) {
            LOGGER.info(String.format("[LOG INFO] Zip File size: %s", file.length()));
            ZipFile zip = new ZipFile(file);
            String content = zip.stream().map(ZipEntry::getName).collect(Collectors.joining(","));
            LOGGER.info(String.format("[LOG INFO] Zip file contents %s ", content));
            zip.close();
        }
        PlanitZipInputStream zis = ZipUtils.createZipInputStream(zipFileLocation);
        ZipUtils.positionZipEntryInputStream(zis, zipEntryFileName);
        return zis;
    }

    public static PlanitZipFileInputStream createZipEntryInputStream(ZipFile zipFile, String zipEntryFileName) throws URISyntaxException, IOException {
        if (zipFile == null || StringUtils.isNullOrBlank(zipEntryFileName)) {
            return null;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().equals(zipEntryFileName)) continue;
            return PlanitZipFileInputStream.of(zipFile, entry);
        }
        return null;
    }

    public static boolean positionZipEntryInputStream(ZipInputStream zipInputStream, String zipEntryFileName) {
        boolean success = false;
        try {
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                if (!entry.getName().equals(zipEntryFileName)) continue;
                success = true;
                break;
            }
        }
        catch (IOException e) {
            LOGGER.severe("Unable to collect next entry stream from zip input stream");
        }
        return success;
    }
}

