/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.misc.Pair;

public class PlanitXmlWriterUtils {
    private static final Logger LOGGER = Logger.getLogger(PlanitXmlWriterUtils.class.getCanonicalName());
    public static final String UTF8 = "UTF-8";
    public static final String XML_V1 = "1.0";

    public static Pair<XMLStreamWriter, Writer> createXMLWriter(Path xmlFilePath) {
        Path absoluteXmlPath = xmlFilePath.toAbsolutePath();
        File directory = absoluteXmlPath.getParent().toFile();
        if (!directory.exists() && !directory.mkdirs()) {
            throw new PlanItRunTimeException(String.format("Unable to create Xml writer output directory %s", directory.toString()));
        }
        Writer theWriter = null;
        try {
            theWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(absoluteXmlPath.toFile()), UTF8);
            XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
            Pair<XMLStreamWriter, Writer> pair = Pair.of(xmlOutputFactory.createXMLStreamWriter(theWriter), theWriter);
            return pair;
        }
        catch (IOException | XMLStreamException e) {
            try {
                theWriter.flush();
                theWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOGGER.severe(e.getMessage());
            throw new PlanItRunTimeException("Could not instantiate XML writer", e);
        }
    }

    public static void writeNewLine(XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeCharacters("\n");
    }

    public static void writeIndentation(XMLStreamWriter xmlWriter, int indentationLevel) throws XMLStreamException {
        for (int index = 0; index < indentationLevel; ++index) {
            xmlWriter.writeCharacters("\t");
        }
    }

    public static void writeEmptyElement(XMLStreamWriter xmlWriter, String xmlElementName, int indentationLevel) throws XMLStreamException {
        PlanitXmlWriterUtils.writeIndentation(xmlWriter, indentationLevel);
        xmlWriter.writeEmptyElement(xmlElementName);
    }

    public static void writeStartElementNewLine(XMLStreamWriter xmlWriter, String xmlElementName, int indentationLevel) throws XMLStreamException {
        PlanitXmlWriterUtils.writeStartElement(xmlWriter, xmlElementName, indentationLevel);
        PlanitXmlWriterUtils.writeNewLine(xmlWriter);
    }

    public static void writeStartElement(XMLStreamWriter xmlWriter, String xmlElementName, int indentationLevel) throws XMLStreamException {
        PlanitXmlWriterUtils.writeIndentation(xmlWriter, indentationLevel);
        xmlWriter.writeStartElement(xmlElementName);
    }

    public static void writeElementWithCData(XMLStreamWriter xmlWriter, String xmlElementName, String elementCData, int indentationLevel) throws XMLStreamException {
        PlanitXmlWriterUtils.writeIndentation(xmlWriter, indentationLevel);
        xmlWriter.writeStartElement(xmlElementName);
        xmlWriter.writeCData(elementCData);
        xmlWriter.writeEndElement();
    }

    public static void writeElementWithCDataNewLine(XMLStreamWriter xmlWriter, String xmlElementName, String elementCData, int indentationLevel) throws XMLStreamException {
        PlanitXmlWriterUtils.writeElementWithCData(xmlWriter, xmlElementName, elementCData, indentationLevel);
        PlanitXmlWriterUtils.writeNewLine(xmlWriter);
    }

    public static void writeElementWithValueWithNewLine(XMLStreamWriter xmlWriter, String xmlElementName, String elementValue, int indentationLevel) throws XMLStreamException {
        PlanitXmlWriterUtils.writeElementWithValue(xmlWriter, xmlElementName, elementValue, indentationLevel);
        PlanitXmlWriterUtils.writeNewLine(xmlWriter);
    }

    public static void writeElementWithValue(XMLStreamWriter xmlWriter, String xmlElementName, String elementValue, int indentationLevel) throws XMLStreamException {
        PlanitXmlWriterUtils.writeStartElement(xmlWriter, xmlElementName, indentationLevel);
        xmlWriter.writeCharacters(elementValue);
        xmlWriter.writeEndElement();
    }

    public static void writeEndElementNewLine(XMLStreamWriter xmlWriter, int indentationLevel) throws XMLStreamException {
        PlanitXmlWriterUtils.writeIndentation(xmlWriter, indentationLevel);
        xmlWriter.writeEndElement();
        PlanitXmlWriterUtils.writeNewLine(xmlWriter);
    }

    public static void startXmlDocument(XMLStreamWriter xmlWriter, String docType) throws XMLStreamException {
        xmlWriter.writeStartDocument(UTF8, XML_V1);
        PlanitXmlWriterUtils.writeNewLine(xmlWriter);
        xmlWriter.writeDTD(docType);
        PlanitXmlWriterUtils.writeNewLine(xmlWriter);
    }

    public static void endXmlDocument(Pair<XMLStreamWriter, Writer> xmlFileWriterPair) throws XMLStreamException, IOException {
        XMLStreamWriter xmlWriter = xmlFileWriterPair.first();
        Writer writer = xmlFileWriterPair.second();
        xmlWriter.writeEndDocument();
        xmlWriter.flush();
        xmlWriter.close();
        writer.flush();
        writer.close();
    }
}

