/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.wrapper;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.goplanit.utils.misc.IterableUtils;

public interface MapWrapper<K, V>
extends Iterable<V> {
    public static <KK, VV> VV firstMatch(MapWrapper<KK, VV> mapWrapper, Predicate<VV> valuePredicate) {
        return mapWrapper.stream().filter(valuePredicate).findFirst().orElse(null);
    }

    public V register(V var1);

    public V remove(V var1);

    default public void removeAll(Collection<V> toBeRemoved) {
        toBeRemoved.forEach(e -> this.remove(e));
    }

    public void removeIf(Predicate<V> var1);

    public void clear();

    public V get(K var1);

    public int size();

    public boolean isEmpty();

    public boolean containsValue(V var1);

    public Collection<V> toCollection();

    public Set<V> valuesAsNewSet();

    public V firstMatch(Predicate<V> var1);

    public MapWrapper<K, V> shallowClone();

    public K getKeyByValue(V var1);

    default public V getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return (V)this.iterator().next();
    }

    default public void addAll(Iterable<? extends V> iterable) {
        iterable.forEach(v -> this.register(v));
    }

    default public <T extends V> void forEachIn(Collection<T> values, Consumer<T> consumer) {
        values.forEach(v -> {
            if (this.containsValue(v)) {
                consumer.accept(v);
            }
        });
    }

    default public <K> Map<K, V> toMap(Function<V, K> getCustomKey) {
        return IterableUtils.toMap(this, getCustomKey, new HashMap());
    }

    default public Stream<V> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public <M extends Comparable> Stream<V> streamSorted(Function<V, M> comparingFunction) {
        return this.stream().sorted(Comparator.comparing(comparingFunction));
    }
}

