/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.unit;

import java.util.logging.Logger;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.unit.SimpleUnit;
import org.goplanit.utils.unit.Unit;
import org.goplanit.utils.unit.UnitGroup;
import org.goplanit.utils.unit.UnitType;

public class VehiclesUnit
extends SimpleUnit {
    private static final Logger LOGGER = Logger.getLogger(VehiclesUnit.class.getCanonicalName());
    public static final double DEFAULT_PCU_VEHICLE_MULTIPLIER = 1.0;
    private static double PCU_2_VEHICLE_FACTOR = 1.0;

    protected VehiclesUnit(UnitType unitType) {
        super(unitType);
        if (!unitType.group.equals((Object)UnitGroup.VEHICLES)) {
            LOGGER.warning(String.format("Invalid unit type %s for vehicles based unit", unitType.name));
            this.unitType = UnitType.NONE;
        }
    }

    public static double convertPcuTo(UnitType unitType, double value) {
        if (!unitType.equals((Object)UnitType.VEH)) {
            throw new PlanItRunTimeException("Conversion illegal or not supported yet from %s --> %s", UnitType.PCU.name, unitType.name);
        }
        return value * PCU_2_VEHICLE_FACTOR;
    }

    public static double convertVehiclesTo(UnitType unitType, double value) {
        if (!unitType.equals((Object)UnitType.PCU)) {
            throw new PlanItRunTimeException("Conversion illegal or not supported yet from %s --> %s", UnitType.VEH.name, unitType.name);
        }
        return value / PCU_2_VEHICLE_FACTOR;
    }

    @Override
    public double convertTo(Unit to, double value) {
        VehiclesUnit toUnit = (VehiclesUnit)to;
        switch (this.unitType) {
            case VEH: {
                return VehiclesUnit.convertVehiclesTo(toUnit.unitType, value);
            }
            case PCU: {
                return VehiclesUnit.convertPcuTo(toUnit.unitType, value);
            }
        }
        throw new PlanItRunTimeException("Unsupported vehicles unit encountered on from Unit");
    }

    public static synchronized void updatePcuToVehicleFactor(double pcuToVehicleFactor) {
        PCU_2_VEHICLE_FACTOR = pcuToVehicleFactor;
    }
}

