/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.unit;

import java.util.logging.Logger;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.unit.SimpleUnit;
import org.goplanit.utils.unit.Unit;
import org.goplanit.utils.unit.UnitGroup;
import org.goplanit.utils.unit.UnitType;

public class SrsUnit
extends SimpleUnit {
    private static final Logger LOGGER = Logger.getLogger(SrsUnit.class.getCanonicalName());

    protected SrsUnit() {
        super(UnitType.SRS);
        if (!this.unitType.group.equals((Object)UnitGroup.SRS)) {
            LOGGER.warning(String.format("Invalid unit type %s for SRS based unit", this.unitType.name));
            this.unitType = UnitType.NONE;
        }
    }

    @Override
    public double convertTo(Unit to, double value) {
        if (!to.isCombinedUnit() && ((SrsUnit)to).unitType.equals((Object)UnitType.SRS)) {
            return value;
        }
        throw new PlanItRunTimeException("Conversion illegal or not supported yet from %s --> %s", new Object[]{UnitType.SRS, to});
    }

    @Override
    public boolean canConvertTo(Unit other) {
        return false;
    }
}

