/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.unit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.goplanit.utils.unit.SimpleUnit;
import org.goplanit.utils.unit.Unit;

public class GroupUnit
implements Unit {
    private final List<SimpleUnit> numeratorUnits;
    private final List<SimpleUnit> denominatorsUnits;

    protected GroupUnit(SimpleUnit ... numeratorUnits) {
        this.numeratorUnits = Arrays.asList(numeratorUnits);
        this.denominatorsUnits = null;
    }

    protected GroupUnit(GroupUnit other, SimpleUnit ... denominatorUnits) {
        this.numeratorUnits = new ArrayList<SimpleUnit>(other.numeratorUnits);
        this.denominatorsUnits = denominatorUnits != null ? List.of(denominatorUnits) : null;
    }

    public GroupUnit per(SimpleUnit ... denominatorUnits) {
        return new GroupUnit(this, denominatorUnits);
    }

    @Override
    public boolean isCombinedUnit() {
        return true;
    }

    protected List<SimpleUnit> getNumeratorUnitTypes() {
        return this.numeratorUnits;
    }

    protected List<SimpleUnit> getDenominatorUnitTypes() {
        return this.denominatorsUnits;
    }

    @Override
    public double convertTo(Unit to, double value) {
        GroupUnit toUnit = (GroupUnit)to;
        double numeratorMultiplier = 1.0;
        Iterator<SimpleUnit> iter = this.getNumeratorUnitTypes().iterator();
        Iterator<SimpleUnit> otherIter = toUnit.getNumeratorUnitTypes().iterator();
        while (iter.hasNext()) {
            numeratorMultiplier *= iter.next().convertTo(otherIter.next(), numeratorMultiplier);
        }
        double denominatorMultiplier = 1.0;
        iter = this.getDenominatorUnitTypes().iterator();
        otherIter = toUnit.getDenominatorUnitTypes().iterator();
        while (iter.hasNext()) {
            denominatorMultiplier *= iter.next().convertTo(otherIter.next(), denominatorMultiplier);
        }
        return value * numeratorMultiplier / denominatorMultiplier;
    }

    @Override
    public boolean canConvertTo(Unit to) {
        if (!this.isCombinedUnit()) {
            return false;
        }
        GroupUnit toUnit = (GroupUnit)to;
        if (this.getNumeratorUnitTypes().size() != toUnit.getNumeratorUnitTypes().size()) {
            return false;
        }
        if (this.getDenominatorUnitTypes().size() != toUnit.getDenominatorUnitTypes().size()) {
            return false;
        }
        int index = 0;
        Iterator<SimpleUnit> iter = this.getNumeratorUnitTypes().iterator();
        while (iter.hasNext()) {
            if (!iter.next().canConvertTo(toUnit.numeratorUnits.get(index))) {
                return false;
            }
            ++index;
        }
        index = 0;
        iter = this.getDenominatorUnitTypes().iterator();
        while (iter.hasNext()) {
            if (!iter.next().canConvertTo(toUnit.denominatorsUnits.get(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        GroupUnit otherUnit = (GroupUnit)o;
        if (!this.canConvertTo(otherUnit)) {
            return false;
        }
        Iterator<SimpleUnit> iter = this.getDenominatorUnitTypes().iterator();
        Iterator<SimpleUnit> otherIter = otherUnit.getDenominatorUnitTypes().iterator();
        while (iter.hasNext()) {
            if (iter.next().equals(otherIter.next())) continue;
            return false;
        }
        iter = this.getNumeratorUnitTypes().iterator();
        otherIter = otherUnit.getNumeratorUnitTypes().iterator();
        while (iter.hasNext()) {
            if (iter.next().equals(otherIter.next())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.numeratorUnits.stream().map(unit -> unit.toString()).collect(Collectors.joining("*")) + "/" + this.denominatorsUnits.stream().map(unit -> unit.toString()).collect(Collectors.joining("*"));
    }
}

