/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.unit;

import java.util.logging.Logger;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.unit.SimpleUnit;
import org.goplanit.utils.unit.Unit;
import org.goplanit.utils.unit.UnitGroup;
import org.goplanit.utils.unit.UnitType;

public class DistanceUnit
extends SimpleUnit {
    private static final Logger LOGGER = Logger.getLogger(DistanceUnit.class.getCanonicalName());
    private static final double KM_2_METER = 1000.0;
    private static final double METER_2_KM = 0.001;

    protected DistanceUnit(UnitType unitType) {
        super(unitType);
        if (!unitType.group.equals((Object)UnitGroup.DISTANCE)) {
            LOGGER.warning(String.format("Invalid unit type %s for distance based unit", unitType.name));
            unitType = UnitType.NONE;
        }
    }

    public static double convertMeterTo(UnitType to, double value) {
        if (to == null) {
            throw new PlanItRunTimeException("To unit null, conversion infeasible");
        }
        switch (to) {
            case METER: {
                return value;
            }
            case KM: {
                return value * 0.001;
            }
        }
        throw new PlanItRunTimeException("Conversion illegal or not supported yet from %s --> %s", new Object[]{UnitType.METER, to});
    }

    public static double convertKmTo(UnitType to, double value) {
        if (to == null) {
            throw new PlanItRunTimeException("to unit null, conversion infeasible");
        }
        switch (to) {
            case METER: {
                return value * 1000.0;
            }
        }
        throw new PlanItRunTimeException("Conversion illegal or not supported yet from %s --> %s", new Object[]{UnitType.KM, to});
    }

    @Override
    public double convertTo(Unit to, double value) {
        DistanceUnit toUnit = (DistanceUnit)to;
        switch (this.unitType) {
            case METER: {
                return DistanceUnit.convertMeterTo(toUnit.unitType, value);
            }
            case KM: {
                return DistanceUnit.convertKmTo(toUnit.unitType, value);
            }
        }
        throw new PlanItRunTimeException("Unsupported distance unit encountered on from Unit");
    }
}

