/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.time;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.goplanit.utils.misc.StringUtils;

public class ExtendedLocalTime
implements Comparable<ExtendedLocalTime> {
    private static final Logger LOGGER = Logger.getLogger(ExtendedLocalTime.class.getCanonicalName());
    private final LocalTime beforeMidnight;
    private final LocalTime beyondMidnight;

    private ExtendedLocalTime(LocalTime beforeMidnight, LocalTime beyondMidnight) {
        this.beforeMidnight = beforeMidnight;
        this.beyondMidnight = beyondMidnight;
    }

    public static boolean isNanosValid(long nanos) {
        return nanos <= LocalTime.MAX.toNanoOfDay() * 2L + 1L && nanos >= 0L;
    }

    public static ExtendedLocalTime of(LocalTime localtime) {
        return new ExtendedLocalTime(localtime, null);
    }

    public static ExtendedLocalTime of(long nanos) {
        if (!ExtendedLocalTime.isNanosValid(nanos)) {
            LOGGER.warning("Cannot create extended local time beyond 48h or with negative value");
            return null;
        }
        if (nanos > LocalTime.MAX.toNanoOfDay()) {
            return ExtendedLocalTime.ofBeyondMidnight(LocalTime.ofNanoOfDay(nanos - (LocalTime.MAX.toNanoOfDay() + 1L)));
        }
        return ExtendedLocalTime.of(LocalTime.ofNanoOfDay(nanos));
    }

    public static ExtendedLocalTime ofBeyondMidnight(LocalTime localtime) {
        return new ExtendedLocalTime(LocalTime.MAX, localtime);
    }

    public static ExtendedLocalTime of(String hh_mm_ss) {
        int hours;
        String[] hhmmssSplit = StringUtils.splitByAnythingExceptAlphaNumeric(hh_mm_ss);
        if (hhmmssSplit == null || hhmmssSplit.length != 3) {
            LOGGER.severe(String.format("Invalid extended local time string format, expected HH:MM:SS, found %s", hh_mm_ss));
        }
        if ((hours = Integer.parseInt(hhmmssSplit[0])) > 47) {
            LOGGER.severe(String.format("Invalid extended local time, expected hours should be less than 48, found %s", hours));
            return null;
        }
        int min = Integer.parseInt(hhmmssSplit[1]);
        if (min > 59) {
            LOGGER.severe(String.format("Invalid extended local time, expected minutes should be less than 59, found %s", min));
            return null;
        }
        int sec = Integer.parseInt(hhmmssSplit[2]);
        if (sec > 59) {
            LOGGER.severe(String.format("Invalid extended local time, expected seconds should be less than 59, found %s", sec));
            return null;
        }
        LocalTime beforeMidnight = null;
        LocalTime beyondMidnight = null;
        if (hours > 23) {
            beforeMidnight = LocalTime.MAX;
            int hoursBeyondMidnight = (int)((long)hours - TimeUnit.DAYS.toHours(1L));
            beyondMidnight = LocalTime.of(hoursBeyondMidnight, min, sec);
        } else {
            beforeMidnight = LocalTime.of(hours, min, sec);
        }
        return new ExtendedLocalTime(beforeMidnight, beyondMidnight);
    }

    public boolean exceedsSingleDay() {
        return this.beyondMidnight != null;
    }

    public LocalTime asLocalTimeBeforeMidnight() {
        return LocalTime.from(this.beforeMidnight);
    }

    public LocalTime asLocalTimeAfterMidnight() {
        if (!this.exceedsSingleDay()) {
            return null;
        }
        return LocalTime.from(this.beyondMidnight);
    }

    public boolean isBefore(ExtendedLocalTime other) {
        return this.compareTo(other) < 0;
    }

    public boolean isAfter(ExtendedLocalTime other) {
        return this.compareTo(other) > 0;
    }

    public ExtendedLocalTime minus(ExtendedLocalTime other) {
        long totalNanos = this.toNanoOfExtendedDay() - other.toNanoOfExtendedDay();
        if (ExtendedLocalTime.isNanosValid(totalNanos)) {
            return ExtendedLocalTime.of(totalNanos);
        }
        LOGGER.severe("Subtracting two local extended times would result in negative time, not allowed");
        return null;
    }

    public ExtendedLocalTime plus(ExtendedLocalTime other) {
        long totalNanos = this.toNanoOfExtendedDay() + other.toNanoOfExtendedDay();
        if (ExtendedLocalTime.isNanosValid(totalNanos)) {
            return ExtendedLocalTime.of(totalNanos);
        }
        LOGGER.severe("Adding two local extended times would exceed 48 hours, not allowed");
        return null;
    }

    public long toNanoOfExtendedDay() {
        return this.beforeMidnight.toNanoOfDay() + (this.exceedsSingleDay() ? this.beyondMidnight.toNanoOfDay() + 1L : 0L);
    }

    public String toString() {
        if (!this.exceedsSingleDay()) {
            return this.beforeMidnight.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
        }
        String extendedHours = StringUtils.zeroPaddedStringOf((int)((long)this.beyondMidnight.getHour() + TimeUnit.DAYS.toHours(1L)), 2);
        return String.join((CharSequence)":", extendedHours, StringUtils.zeroPaddedStringOf(this.beyondMidnight.getMinute(), 2), StringUtils.zeroPaddedStringOf(this.beyondMidnight.getSecond(), 2));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExtendedLocalTime)) {
            return false;
        }
        ExtendedLocalTime other = (ExtendedLocalTime)obj;
        return this.beforeMidnight.equals(other.beforeMidnight) && (this.exceedsSingleDay() && this.beyondMidnight.equals(other.beyondMidnight) || !other.exceedsSingleDay());
    }

    @Override
    public int compareTo(ExtendedLocalTime o) {
        if (this.equals(o)) {
            return 0;
        }
        long diff = this.toNanoOfExtendedDay() - o.toNanoOfExtendedDay();
        return diff < 0L ? -1 : 1;
    }

    public int hashCode() {
        return Objects.hash(this.beforeMidnight, this.beyondMidnight);
    }
}

