/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.service.routed;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;
import org.goplanit.utils.service.routed.RelativeLegTiming;
import org.goplanit.utils.service.routed.RoutedTripSchedule;
import org.goplanit.utils.service.routed.RoutedTripScheduleFactory;
import org.goplanit.utils.service.routed.RoutedTrips;

public interface RoutedTripsSchedule
extends RoutedTrips<RoutedTripSchedule> {
    @Override
    public RoutedTripScheduleFactory getFactory();

    default public Map<List<ServiceLegSegment>, List<RoutedTripSchedule>> groupByServiceLegSegments() {
        return this.groupBy(rts -> rts.getRelativeLegTimingsAsStream().map(rlt -> rlt.getParentLegSegment()).collect(Collectors.toList()));
    }

    default public Map<List<LinkSegment>, List<RoutedTripSchedule>> groupByPhysicalLinkSegments() {
        return this.groupBy(rts -> rts.getRelativeLegTimingsAsStream().flatMap(rlt -> rlt.getParentLegSegment().getPhysicalParentSegments().stream()).collect(Collectors.toList()));
    }

    default public Map<List<RelativeLegTiming>, List<RoutedTripSchedule>> groupByRelativeLegTimings() {
        return this.groupBy(rts -> rts.getRelativeLegTimingsAsStream().collect(Collectors.toList()));
    }

    @Override
    public RoutedTripsSchedule shallowClone();

    @Override
    public RoutedTripsSchedule deepClone();

    public RoutedTripsSchedule deepCloneWithMapping(BiConsumer<RoutedTripSchedule, RoutedTripSchedule> var1);
}

