/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.service.routed;

import java.time.LocalTime;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.misc.IterableUtils;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;
import org.goplanit.utils.service.routed.RelativeLegTiming;
import org.goplanit.utils.service.routed.RoutedTrip;
import org.goplanit.utils.service.routed.RoutedTripDepartures;

public interface RoutedTripSchedule
extends RoutedTrip,
Iterable<RelativeLegTiming> {
    public RoutedTripDepartures getDepartures();

    default public boolean hasDepartures() {
        return !this.getDepartures().isEmpty();
    }

    public void clearRelativeLegTimings();

    public void clearDepartures();

    public RelativeLegTiming addRelativeLegSegmentTiming(ServiceLegSegment var1, LocalTime var2, LocalTime var3);

    public RelativeLegTiming getRelativeLegTiming(int var1);

    public int getRelativeLegTimingsSize();

    default public RelativeLegTiming getLastRelativeLegTiming() {
        return this.getRelativeLegTiming(this.getLastRelativeLegTimingIndex());
    }

    default public int getLastRelativeLegTimingIndex() {
        return this.hasRelativeLegTimings() ? this.getRelativeLegTimingsSize() - 1 : -1;
    }

    default public Stream<RelativeLegTiming> getRelativeLegTimingsAsStream() {
        return IterableUtils.asStream(this);
    }

    public LocalTime getDefaultDwellTime();

    public LocalTime updateDefaultDwellTimeToMostCommon();

    default public RelativeLegTiming getFirstRelativeLegTiming() {
        return this.getRelativeLegTiming(0);
    }

    default public boolean hasRelativeLegTimings() {
        return this.getRelativeLegTimingsSize() > 0;
    }

    default public boolean isValidRelativeLegTimingsIndex(int relTimingsIndex) {
        return relTimingsIndex > 0 && relTimingsIndex < this.getRelativeLegTimingsSize();
    }

    default public void clear() {
        this.clearDepartures();
        this.clearRelativeLegTimings();
    }

    public void removeLegTiming(int var1);

    default public void removeLegTimingsIn(List<Integer> legTimingIndices) {
        Iterator<Integer> iter = legTimingIndices.iterator();
        int indexOffset = 0;
        int prevIndex = -1;
        while (iter.hasNext()) {
            int indexToRemove = iter.next() - indexOffset;
            if (indexToRemove <= prevIndex || indexToRemove < 0) {
                throw new PlanItRunTimeException(String.format("leg timing indices cannot contain duplicates and should be provided in valid ascending order (curr %d, prev %d", new Object[0]), indexToRemove, prevIndex);
            }
            this.removeLegTiming(indexToRemove);
            ++indexOffset;
        }
    }

    @Override
    public RoutedTripSchedule shallowClone();

    @Override
    public RoutedTripSchedule deepClone();
}

