/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.service.routed;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.goplanit.utils.network.layer.ServiceNetworkLayer;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;
import org.goplanit.utils.network.layer.service.ServiceLegSegmentUtils;
import org.goplanit.utils.service.routed.RoutedTripFrequency;

public class RoutedTripFrequencyUtils {
    public static boolean isRoutedTripFrequencyMappedToServiceNetwork(RoutedTripFrequency routedTripFrequency, ServiceNetworkLayer serviceNetworkLayer) {
        ServiceLegSegment serviceLegSegment;
        boolean isMapped = routedTripFrequency.hasLegSegments();
        if (!isMapped) {
            return false;
        }
        Iterator iterator = routedTripFrequency.iterator();
        while (iterator.hasNext() && (isMapped = ServiceLegSegmentUtils.isMappedToServiceNetwork(serviceLegSegment = (ServiceLegSegment)iterator.next(), serviceNetworkLayer))) {
        }
        return isMapped;
    }

    public static List<Integer> findServiceLegSegmentsNotMappedToServiceNetwork(RoutedTripFrequency routedTripFrequency, ServiceNetworkLayer serviceNetworkLayer) {
        ArrayList<Integer> result = null;
        for (int index = 0; index < routedTripFrequency.getNumberOfLegSegments(); ++index) {
            if (ServiceLegSegmentUtils.isMappedToServiceNetwork(routedTripFrequency.getLegSegment(index), serviceNetworkLayer)) continue;
            if (result == null) {
                result = new ArrayList<Integer>(5);
            }
            result.add(index);
        }
        return result;
    }
}

