/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.service.routed;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;
import org.goplanit.utils.service.routed.RoutedTrip;

public interface RoutedTripFrequency
extends RoutedTrip,
Iterable<ServiceLegSegment> {
    public void clearLegs();

    public int getNumberOfLegSegments();

    public void addLegSegment(ServiceLegSegment var1);

    public ServiceLegSegment getLegSegment(int var1);

    public double getFrequencyPerHour();

    public void setFrequencyPerHour(double var1);

    default public boolean hasPositiveFrequency() {
        return this.getFrequencyPerHour() > 0.0;
    }

    default public boolean hasLegSegments() {
        return this.getNumberOfLegSegments() > 0;
    }

    default public ServiceLegSegment getFirstLegSegment() {
        return this.getLegSegment(0);
    }

    default public ServiceLegSegment getLastLegSegment() {
        if (!this.hasLegSegments()) {
            return null;
        }
        return this.getLegSegment(this.getNumberOfLegSegments() - 1);
    }

    public void removeLegSegment(int var1);

    public void removeAllLegSegments();

    @Override
    public RoutedTripFrequency shallowClone();

    @Override
    public RoutedTripFrequency deepClone();

    default public void clear() {
        this.setFrequencyPerHour(0.0);
        this.removeAllLegSegments();
    }

    default public void removeLegSegmentsIn(List<Integer> segmentIndicesToRemove) {
        Iterator<Integer> iter = segmentIndicesToRemove.iterator();
        int indexOffset = 0;
        int prevIndex = -1;
        while (iter.hasNext()) {
            int indexToRemove = iter.next() - indexOffset;
            if (indexToRemove <= prevIndex) {
                throw new PlanItRunTimeException("trip frequency service leg segment's to remove cannot contain duplicates and should be provided in ascending order");
            }
            this.removeLegSegment(indexToRemove);
            ++indexOffset;
        }
    }

    default public int getLastSegmentIndex() {
        return this.getNumberOfLegSegments() - 1;
    }

    default public Stream<ServiceLegSegment> getLegSegmentsAsStream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

