/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.service.routed;

import java.util.Collection;
import java.util.stream.Collectors;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.id.ManagedId;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.ServiceNetworkLayer;
import org.goplanit.utils.service.routed.RoutedModeServices;
import org.goplanit.utils.service.routed.modifier.RoutedServicesLayerModifier;

public interface RoutedServicesLayer
extends ManagedId,
ExternalIdAble,
Iterable<RoutedModeServices> {
    public static final Class<RoutedServicesLayer> ROUTED_SERVICES_LAYER_ID_CLASS = RoutedServicesLayer.class;

    default public Class<RoutedServicesLayer> getIdClass() {
        return ROUTED_SERVICES_LAYER_ID_CLASS;
    }

    public void logInfo(String var1);

    public boolean isEmpty();

    public ServiceNetworkLayer getParentLayer();

    public boolean isServicesByModeEmpty(Mode var1);

    public RoutedModeServices getServicesByMode(Mode var1);

    @Override
    default public void resetChildManagedIdEntities() {
        this.forEach(routedModeServices -> routedModeServices.reset());
    }

    default public Collection<Mode> getSupportedModes() {
        return this.getParentLayer().getSupportedModes();
    }

    default public Collection<Mode> getSupportedModesWithServices() {
        return this.getParentLayer().getSupportedModes().stream().filter(m -> !this.isServicesByModeEmpty((Mode)m)).collect(Collectors.toList());
    }

    public RoutedServicesLayerModifier getLayerModifier();

    @Override
    public RoutedServicesLayer shallowClone();

    @Override
    public RoutedServicesLayer deepClone();
}

