/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.service.routed;

import java.util.stream.Stream;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;
import org.goplanit.utils.service.routed.RoutedTripsFrequency;
import org.goplanit.utils.service.routed.RoutedTripsSchedule;

public interface RoutedServiceTripInfo {
    public RoutedServiceTripInfo shallowClone();

    public RoutedServiceTripInfo deepClone();

    public RoutedTripsFrequency getFrequencyBasedTrips();

    public RoutedTripsSchedule getScheduleBasedTrips();

    default public boolean hasFrequencyBasedTrips() {
        return this.getFrequencyBasedTrips() != null && !this.getFrequencyBasedTrips().isEmpty();
    }

    default public boolean hasScheduleBasedTrips() {
        return this.getScheduleBasedTrips() != null && !this.getScheduleBasedTrips().isEmpty();
    }

    public void reset();

    default public boolean hasAnyTrips() {
        return this.hasScheduleBasedTrips() || this.hasFrequencyBasedTrips();
    }

    default public Stream<ServiceLegSegment> getLegSegmentsStream() {
        Stream<ServiceLegSegment> scheduleStream = this.getScheduleBasedTrips().stream().flatMap(ts -> ts.getRelativeLegTimingsAsStream()).map(rlt -> rlt.getParentLegSegment());
        Stream freqStream = this.getFrequencyBasedTrips().stream().flatMap(ft -> ft.getLegSegmentsAsStream());
        return Stream.concat(scheduleStream, freqStream);
    }
}

