/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.service.routed;

import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.id.ManagedId;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;
import org.goplanit.utils.service.routed.RoutedServiceTripInfo;
import org.goplanit.utils.service.routed.RoutedTripsSchedule;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;

public interface RoutedService
extends ManagedId,
ExternalIdAble {
    public static final Class<RoutedService> ROUTED_SERVICE_ID_CLASS = RoutedService.class;

    default public Class<RoutedService> getIdClass() {
        return ROUTED_SERVICE_ID_CLASS;
    }

    @Override
    public RoutedService shallowClone();

    @Override
    public RoutedService deepClone();

    public String getName();

    default public boolean hasName() {
        return !StringUtils.isNullOrBlank(this.getName());
    }

    public void setName(String var1);

    public String getNameDescription();

    default public boolean hasNameDescription() {
        return !StringUtils.isNullOrBlank(this.getNameDescription());
    }

    public void setNameDescription(String var1);

    public String getServiceDescription();

    default public boolean hasServiceDescription() {
        return StringUtils.isNullOrBlank(this.getServiceDescription());
    }

    public void setServiceDescription(String var1);

    public RoutedServiceTripInfo getTripInfo();

    public Mode getMode();

    default public MultiLineString extractGeometry(boolean includeScheduledTrips, boolean includeFrequencyBasedTrips) {
        RoutedTripsSchedule scheduleTrips = this.getTripInfo().getScheduleBasedTrips();
        Stream<ServiceLegSegment> scheduledLegSegmentStream = scheduleTrips.stream().flatMap(srt -> srt.getRelativeLegTimingsAsStream()).map(rlt -> rlt.getParentLegSegment());
        Stream frequencyTripLegSegmentStream = this.getTripInfo().getFrequencyBasedTrips().stream().flatMap(frt -> frt.getLegSegmentsAsStream());
        Stream<ServiceLegSegment> allLegSegmentStream = Stream.concat(includeScheduledTrips ? scheduledLegSegmentStream : Stream.empty(), includeFrequencyBasedTrips ? frequencyTripLegSegmentStream : Stream.empty()).distinct();
        TreeSet legSegmentsAsLineStrings = allLegSegmentStream.map(ls -> ls.getGeometry()).collect(Collectors.toCollection(TreeSet::new));
        return PlanitJtsUtils.createMultiLineString(legSegmentsAsLineStrings.toArray(new LineString[legSegmentsAsLineStrings.size()]));
    }
}

