/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.service.routed;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.network.layer.service.ServiceLegSegments;
import org.goplanit.utils.network.layer.service.ServiceNodes;
import org.goplanit.utils.service.routed.RelativeLegTiming;
import org.goplanit.utils.service.routed.RoutedServicesLayer;
import org.goplanit.utils.service.routed.RoutedTripSchedule;

public class RelativeLegTimingUtils {
    public static boolean isLegTimingMappedToServiceNetwork(RelativeLegTiming relativeLegTiming, ServiceLegSegments legSegments, ServiceNodes serviceNodes) {
        return relativeLegTiming.hasParentLegSegment() && legSegments.hasServiceLegSegment(relativeLegTiming.getParentLegSegment()) && relativeLegTiming.getParentLegSegment().hasParent() && relativeLegTiming.getParentLegSegment().getParent().hasVertices() && serviceNodes.hasServiceNode(relativeLegTiming.getParentLegSegment().getUpstreamServiceNode()) && serviceNodes.hasServiceNode(relativeLegTiming.getParentLegSegment().getDownstreamServiceNode());
    }

    public static int findNextTimingLegMappedToServiceNetwork(int offsetLegIndex, RoutedTripSchedule routedTripSchedule, RoutedServicesLayer routedServiceLayer) {
        int relTimingSize = routedTripSchedule.getRelativeLegTimingsSize();
        if (offsetLegIndex < 0 || offsetLegIndex >= relTimingSize) {
            throw new PlanItRunTimeException("provided invalid index for relative timing search offset");
        }
        ServiceNodes serviceNodes = routedServiceLayer.getParentLayer().getServiceNodes();
        ServiceLegSegments legSegments = routedServiceLayer.getParentLayer().getLegSegments();
        int currLegTimingIndex = offsetLegIndex - 1;
        boolean isInvalid = true;
        RelativeLegTiming currLegtiming = null;
        while (isInvalid && ++currLegTimingIndex < relTimingSize) {
            currLegtiming = routedTripSchedule.getRelativeLegTiming(currLegTimingIndex);
            isInvalid = !RelativeLegTimingUtils.isLegTimingMappedToServiceNetwork(currLegtiming, legSegments, serviceNodes);
        }
        return currLegTimingIndex;
    }

    public static List<Integer> findLegTimingsNotMappedToServiceNetwork(RoutedTripSchedule routedTripSchedule, RoutedServicesLayer routedServicesLayer) {
        int currFoundValidLegIndex = RelativeLegTimingUtils.findNextTimingLegMappedToServiceNetwork(0, routedTripSchedule, routedServicesLayer);
        List<Integer> toBeRemovedLegSegments = IntStream.range(0, currFoundValidLegIndex).boxed().collect(Collectors.toList());
        if (toBeRemovedLegSegments.size() == routedTripSchedule.getRelativeLegTimingsSize()) {
            return toBeRemovedLegSegments;
        }
        int nextFoundValidLegIndex = -1;
        int maxLegIndex = routedTripSchedule.getRelativeLegTimingsSize();
        while (routedTripSchedule.isValidRelativeLegTimingsIndex(currFoundValidLegIndex + 1)) {
            nextFoundValidLegIndex = RelativeLegTimingUtils.findNextTimingLegMappedToServiceNetwork(currFoundValidLegIndex + 1, routedTripSchedule, routedServicesLayer);
            if (currFoundValidLegIndex + 1 != nextFoundValidLegIndex) {
                List toBeRemovedLegSegmentPartialList = IntStream.range(currFoundValidLegIndex + 1, Math.min(maxLegIndex, nextFoundValidLegIndex)).boxed().collect(Collectors.toList());
                if (toBeRemovedLegSegments == null) {
                    toBeRemovedLegSegments = toBeRemovedLegSegmentPartialList;
                } else {
                    toBeRemovedLegSegments.addAll(toBeRemovedLegSegmentPartialList);
                }
            }
            currFoundValidLegIndex = nextFoundValidLegIndex;
        }
        return toBeRemovedLegSegments;
    }
}

