/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.exceptions.PlanItRunTimeException;

public class ReflectionUtils {
    private static final Logger LOGGER = Logger.getLogger(ReflectionUtils.class.getCanonicalName());

    public static Class<?>[] getParameterTypes(Object[] parameters) {
        List parameterTypes = Arrays.stream(parameters).map(Object::getClass).collect(Collectors.toList());
        return (Class[])parameterTypes.toArray(Class[]::new);
    }

    public static <T> T createTypedInstance(String className, Object ... constructorParameters) throws PlanItException {
        return (T)ReflectionUtils.createInstance(className, constructorParameters);
    }

    public static Object createInstance(String className, Object ... constructorParameters) {
        Object createdInstance = null;
        if (constructorParameters != null) {
            Constructor<?> constructor = null;
            try {
                Class<?>[] parameterTypes = ReflectionUtils.getParameterTypes(constructorParameters);
                constructor = Class.forName(className).getConstructor(parameterTypes);
            }
            catch (Exception e) {
                LOGGER.severe(String.format("Unable to find constructor for given arguments when constructing instance of %s with constructor parameters %s\n likely constructor either requires different number of arguments or it requires super types \nwhereas provided arguments are implementations of this type \nand reflection is not able to infer this as a valid call, see also https://github.com/TrafficPLANit/PLANitUtils/issues/7", className, Arrays.toString(constructorParameters)));
                e.printStackTrace();
                LOGGER.severe(e.getMessage());
                throw new PlanItRunTimeException("Unable to find appropriate constructor for type: " + className, e);
            }
            try {
                createdInstance = constructor.newInstance(constructorParameters);
            }
            catch (Exception e) {
                throw new PlanItRunTimeException("Unable to create instance of type: " + className, e);
            }
        }
        try {
            createdInstance = Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new PlanItRunTimeException("Unable to create instance of type via default constructor: " + className, e);
        }
        return createdInstance;
    }

    public static Map<String, Object> declaredFieldsNameValueMap(Object settingsClazzInstance, Function<Integer, Boolean> modifierFilter) {
        BiFunction<Field, Object, Object> biFunction = (field, object) -> {
            Object value = null;
            try {
                boolean old = field.canAccess(object);
                field.setAccessible(true);
                value = field.get(object);
                field.setAccessible(old);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return value;
        };
        return ReflectionUtils.declaredFieldsToMap(settingsClazzInstance, Field::getName, biFunction, modifierFilter);
    }

    public static <K, V> Map<K, V> declaredFieldsToMap(Object settingsClazzInstance, Function<Field, K> keyFunction, BiFunction<Field, Object, V> valueFunction, Function<Integer, Boolean> modifierFilter) {
        Field[] fields = settingsClazzInstance.getClass().getDeclaredFields();
        HashMap<K, V> fieldValueMap = new HashMap<K, V>();
        for (int index = 0; index < fields.length; ++index) {
            Field field = fields[index];
            try {
                if (!modifierFilter.apply(field.getModifiers()).booleanValue()) continue;
                fieldValueMap.put(keyFunction.apply(field), valueFunction.apply(field, settingsClazzInstance));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fieldValueMap;
    }
}

