/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.od;

import java.util.logging.Logger;
import org.goplanit.utils.id.IdAble;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.od.OdMatrixImpl;
import org.goplanit.utils.od.OdMatrixIterator;
import org.goplanit.utils.zoning.OdZones;
import org.goplanit.utils.zoning.Zone;
import org.ojalgo.array.Array2D;
import org.ojalgo.structure.Access2D;

public abstract class OdPrimitiveMatrix<T extends Number>
extends OdMatrixImpl<T, Array2D<T>> {
    private static final Logger LOGGER = Logger.getLogger(OdPrimitiveMatrix.class.getCanonicalName());

    public OdPrimitiveMatrix(Class<? extends IdAble> idTokenClass, IdGroupingToken idToken, OdZones zones, Array2D<T> matrixContents) {
        super(idTokenClass, idToken, zones, matrixContents);
    }

    public OdPrimitiveMatrix(OdPrimitiveMatrix<T> other, Array2D.Factory<T> contentFactory) {
        super(other);
        this.matrixContents = contentFactory.copy((Access2D)other.matrixContents);
    }

    @Override
    public void setValue(Zone origin, Zone destination, T value) {
        ((Array2D)this.matrixContents).set(origin.getId(), destination.getId(), value);
    }

    @Override
    public T getValue(Zone origin, Zone destination) {
        return (T)((Array2D)this.matrixContents).get(origin.getId(), destination.getId());
    }

    @Override
    public T getValue(long originId, long destinationId) {
        return (T)((Array2D)this.matrixContents).get(originId, destinationId);
    }

    @Override
    public abstract OdPrimitiveMatrix<T> shallowClone();

    @Override
    public OdPrimitiveMatrix<T> deepClone() {
        return this.shallowClone();
    }

    @Override
    public abstract OdMatrixIterator<T, Array2D<T>> iterator();
}

