/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.od;

import org.goplanit.utils.od.OdDataIterator;
import org.goplanit.utils.od.OdHashed;
import org.goplanit.utils.zoning.OdZones;
import org.goplanit.utils.zoning.Zone;

public abstract class OdHashedIterator<T>
implements OdDataIterator<T> {
    private final OdHashed<T> container;
    protected int originId;
    protected int destinationId;
    protected int currentLocation = 0;
    protected OdZones zones;

    protected void updateCurrentLocation() {
        do {
            this.originId = this.currentLocation / this.container.getNumberOfOdZones();
            this.destinationId = this.currentLocation % this.container.getNumberOfOdZones();
            ++this.currentLocation;
        } while (this.getCurrentValue() == null && this.hasNext());
    }

    public OdHashedIterator(OdHashed<T> container, OdZones zones) {
        this.container = container;
        this.zones = zones;
    }

    @Override
    public boolean hasNext() {
        return this.currentLocation < this.container.getNumberOfOdZones() * this.container.getNumberOfOdZones();
    }

    @Override
    public Zone getCurrentOrigin() {
        return (Zone)this.zones.get(this.originId);
    }

    @Override
    public Zone getCurrentDestination() {
        return (Zone)this.zones.get(this.destinationId);
    }

    @Override
    public T next() {
        this.updateCurrentLocation();
        return this.getCurrentValue();
    }

    @Override
    public T getCurrentValue() {
        return this.container.getValue(this.originId, this.destinationId);
    }
}

