/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.network.virtual;

import java.util.logging.Logger;
import org.goplanit.utils.graph.GraphEntityDeepCopyMapper;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.IterableUtils;
import org.goplanit.utils.network.virtual.CentroidVertex;
import org.goplanit.utils.network.virtual.CentroidVertices;
import org.goplanit.utils.network.virtual.ConjugateVirtualNetwork;
import org.goplanit.utils.network.virtual.ConnectoidEdge;
import org.goplanit.utils.network.virtual.ConnectoidEdges;
import org.goplanit.utils.network.virtual.ConnectoidSegment;
import org.goplanit.utils.network.virtual.ConnectoidSegments;

public interface VirtualNetwork {
    public static final Logger LOGGER = Logger.getLogger(VirtualNetwork.class.getCanonicalName());

    public ConnectoidSegments getConnectoidSegments();

    public ConnectoidEdges getConnectoidEdges();

    public CentroidVertices getCentroidVertices();

    public void clear();

    public void reset();

    public ConjugateVirtualNetwork createConjugate(IdGroupingToken var1);

    public VirtualNetwork shallowClone();

    public VirtualNetwork deepClone();

    public VirtualNetwork deepCloneWithMapping(GraphEntityDeepCopyMapper<ConnectoidEdge> var1, GraphEntityDeepCopyMapper<ConnectoidSegment> var2, GraphEntityDeepCopyMapper<CentroidVertex> var3);

    default public boolean isEmpty() {
        return this.getCentroidVertices().isEmpty() && this.getConnectoidEdges().isEmpty() && this.getConnectoidSegments().isEmpty();
    }

    default public boolean hasConnectoidEdges() {
        return !IterableUtils.nullOrEmpty(this.getConnectoidEdges());
    }

    default public boolean hasConnectoidSegments() {
        return !IterableUtils.nullOrEmpty(this.getConnectoidSegments());
    }
}

