/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.network.layers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.BiConsumer;
import org.goplanit.utils.id.ManagedIdEntities;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.PredefinedModeType;
import org.goplanit.utils.network.layer.NetworkLayer;

public interface NetworkLayers<T extends NetworkLayer>
extends ManagedIdEntities<T> {
    @Override
    public T get(Mode var1);

    public T getByXmlId(String var1);

    default public boolean isEachLayerEmpty() {
        boolean eachLayerEmpty = true;
        for (NetworkLayer layer : this) {
            if (layer.isEmpty()) continue;
            eachLayerEmpty = false;
            break;
        }
        return eachLayerEmpty;
    }

    default public <U extends NetworkLayer> Collection<U> getLayersOfType() {
        ArrayList<NetworkLayer> layerList = new ArrayList<NetworkLayer>();
        for (NetworkLayer layer : this) {
            try {
                NetworkLayer castLayer = layer;
                layerList.add(castLayer);
            }
            catch (ClassCastException classCastException) {}
        }
        return layerList;
    }

    default public Collection<Mode> getSupportedModes() {
        HashSet<Mode> modes = new HashSet<Mode>();
        this.forEach(l -> modes.addAll(l.getSupportedModes()));
        return modes;
    }

    @Override
    public NetworkLayers<T> shallowClone();

    @Override
    public NetworkLayers<T> deepClone();

    @Override
    public NetworkLayers<T> deepCloneWithMapping(BiConsumer<T, T> var1);

    @Override
    default public T get(PredefinedModeType predefinedModeType) {
        return (T)this.firstMatch(l -> l.supports(predefinedModeType));
    }
}

