/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.network.layer.service;

import java.util.List;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.service.ServiceLeg;
import org.goplanit.utils.network.layer.service.ServiceNode;
import org.locationtech.jts.geom.LineString;

public interface ServiceLegSegment
extends EdgeSegment {
    @Override
    public ServiceLeg getParent();

    public LineString getGeometry();

    @Override
    public ServiceLegSegment shallowClone();

    @Override
    public ServiceLegSegment deepClone();

    default public ServiceNode getUpstreamServiceNode() {
        return this.isDirectionAb() ? this.getParent().getServiceNodeA() : this.getParent().getServiceNodeB();
    }

    default public ServiceNode getDownstreamServiceNode() {
        return this.isDirectionAb() ? this.getParent().getServiceNodeB() : this.getParent().getServiceNodeA();
    }

    @Override
    default public boolean hasGeometry() {
        if (this.getPhysicalParentSegments() == null || this.getPhysicalParentSegments().isEmpty()) {
            return false;
        }
        return this.getPhysicalParentSegments().stream().allMatch(ls -> ls.hasGeometry());
    }

    public List<? extends LinkSegment> getPhysicalParentSegments();

    public void setPhysicalParentSegments(List<? extends LinkSegment> var1);

    default public boolean hasPhysicalParentSegments() {
        return this.getPhysicalParentSegments() != null && !this.getPhysicalParentSegments().isEmpty();
    }

    default public LinkSegment getFirstPhysicalLinkSegment() {
        return this.getPhysicalParentSegments().get(0);
    }

    default public LinkSegment getLastPhysicalLinkSegment() {
        return this.getPhysicalParentSegments().get(this.getPhysicalParentSegments().size() - 1);
    }
}

