/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.network.layer.physical;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.physical.Node;

public interface LinkSegment
extends EdgeSegment {
    public static final Class<LinkSegment> LINK_SEGMENT_ID_CLASS = LinkSegment.class;
    public static final short DEFAULT_NUMBER_OF_LANES = 1;
    public static final double DEFAULT_MAX_SPEED = 130.0;
    public static final double MAXIMUM_DENSITY = 180.0;

    default public Class<? extends LinkSegment> getLinkSegmentIdClass() {
        return LINK_SEGMENT_ID_CLASS;
    }

    default public long generateLinkSegmentId(IdGroupingToken groupId) {
        return IdGenerator.generateId(groupId, this.getLinkSegmentIdClass());
    }

    public boolean isModeAllowed(Mode var1);

    public Set<Mode> getAllowedModes();

    default public Set<Mode> getAllowedModesFrom(Collection<Mode> modes) {
        HashSet<Mode> allowedModes = new HashSet<Mode>();
        for (Mode mode : modes) {
            if (!this.isModeAllowed(mode)) continue;
            allowedModes.add(mode);
        }
        return allowedModes;
    }

    public long getLinkSegmentId();

    public int getNumberOfLanes();

    public LinkSegment setNumberOfLanes(int var1);

    public LinkSegment setPhysicalSpeedLimitKmH(double var1);

    public double getPhysicalSpeedLimitKmH();

    @Override
    public Link getParent();

    @Override
    public Node getUpstreamVertex();

    @Override
    public Node getDownstreamVertex();

    default public boolean isDownstreamNode(Node node) {
        return this.getDownstreamNode().equals(node);
    }

    default public boolean hasNode(Node node) {
        return this.isDownstreamNode(node) || this.isUpstreamNode(node);
    }

    default public boolean isUpstreamNode(Node node) {
        return this.getUpstreamNode().equals(node);
    }

    @Override
    public LinkSegment shallowClone();

    @Override
    public LinkSegment deepClone();

    default public Link getParentLink() {
        return this.getParent();
    }

    default public Node getUpstreamNode() {
        return this.getUpstreamVertex();
    }

    default public Node getDownstreamNode() {
        return this.getDownstreamVertex();
    }
}

