/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.network.layer.modifier;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.graph.directed.DirectedEdge;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.graph.modifier.event.GraphModifierEventProducer;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.network.layer.modifier.TopologicalLayerModifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public interface UntypedDirectedGraphLayerModifier<V extends DirectedVertex, E extends DirectedEdge, S extends EdgeSegment>
extends TopologicalLayerModifier,
GraphModifierEventProducer {
    default public Map<Long, Pair<E, E>> breakAt(E linkToBreak, V nodeToBreakAt, CoordinateReferenceSystem crs) {
        return this.breakAt(List.of(linkToBreak), nodeToBreakAt, crs);
    }

    public Map<Long, Pair<E, E>> breakAt(List<E> var1, V var2, CoordinateReferenceSystem var3);

    default public <K> Map<K, Set<E>> breakAt(List<E> linksToBreak, V nodeToBreakAt, CoordinateReferenceSystem crs, Function<E, K> linkToKey) {
        HashMap groupNewLinksByOriginalLinkKey = new HashMap();
        if (linksToBreak != null) {
            try {
                Map<Long, Pair<E, E>> localBrokenLinks = this.breakAt(linksToBreak, nodeToBreakAt, crs);
                if (localBrokenLinks != null) {
                    localBrokenLinks.forEach((id, links) -> List.of((DirectedEdge)links.first(), (DirectedEdge)links.second()).forEach(brokenLink -> {
                        Object brokenLinkKey = linkToKey.apply(brokenLink);
                        groupNewLinksByOriginalLinkKey.putIfAbsent(brokenLinkKey, new HashSet());
                        ((Set)groupNewLinksByOriginalLinkKey.get(brokenLinkKey)).add(brokenLink);
                    }));
                }
            }
            catch (PlanItRunTimeException e) {
                throw new PlanItRunTimeException("Unable to break links %s for node %s, something unexpected went wrong", (Throwable)e, linksToBreak.stream().map(link -> link.getExternalId()).collect(Collectors.toSet()).toString(), nodeToBreakAt.getExternalId());
            }
        }
        return groupNewLinksByOriginalLinkKey;
    }

    public void recreateManagedIdEntities();
}

