/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.network.layer.macroscopic;

import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLink;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.pcu.PcuCapacitated;

public interface MacroscopicLinkSegment
extends LinkSegment,
PcuCapacitated {
    public double computeFreeFlowTravelTimeHour(Mode var1);

    default public double getModelledSpeedLimitKmH(Mode mode) {
        if (!this.isModeAllowed(mode)) {
            return 0.0;
        }
        return Math.min(this.getPhysicalSpeedLimitKmH(), this.getLinkSegmentType().getMaximumSpeedKmH(mode));
    }

    public void setLinkSegmentType(MacroscopicLinkSegmentType var1);

    public MacroscopicLinkSegmentType getLinkSegmentType();

    default public boolean hasLinkSegmentType() {
        return this.getLinkSegmentType() != null;
    }

    @Override
    public Node getUpstreamVertex();

    @Override
    public Node getDownstreamVertex();

    @Override
    default public MacroscopicLink getParentLink() {
        return (MacroscopicLink)LinkSegment.super.getParentLink();
    }

    @Override
    default public double getCapacityOrDefaultPcuH() {
        return this.getCapacityOrDefaultPcuHLane() * (double)this.getNumberOfLanes();
    }

    @Override
    default public double getCapacityOrDefaultPcuHLane() {
        return this.getLinkSegmentType().getExplicitCapacityPerLaneOrDefault();
    }

    @Override
    public MacroscopicLinkSegment shallowClone();

    @Override
    public MacroscopicLinkSegment deepClone();
}

