/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.network.layer.macroscopic;

import java.util.Collection;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.physical.Link;

public interface MacroscopicLink
extends Link {
    @Override
    default public MacroscopicLinkSegment getLinkSegment(boolean directionAb) {
        return (MacroscopicLinkSegment)Link.super.getLinkSegment(directionAb);
    }

    @Override
    default public MacroscopicLinkSegment getLinkSegmentAb() {
        return this.getLinkSegment(true);
    }

    @Override
    default public MacroscopicLinkSegment getLinkSegmentBa() {
        return this.getLinkSegment(false);
    }

    default public Collection<? extends MacroscopicLinkSegment> getLinkSegments() {
        return this.getEdgeSegments();
    }

    default public boolean isModeAllowedOnAnySegment(Mode mode) {
        return (this.hasLinkSegmentBa() || this.hasLinkSegmentBa()) && (this.hasLinkSegmentBa() && this.getLinkSegmentBa().isModeAllowed(mode) || this.hasLinkSegmentAb() && this.getLinkSegmentAb().isModeAllowed(mode));
    }

    default public boolean isModeAllowedOnAllSegments(Mode mode) {
        return !(!this.hasLinkSegmentBa() && !this.hasLinkSegmentBa() || this.hasLinkSegmentBa() && !this.getLinkSegmentBa().isModeAllowed(mode) || this.hasLinkSegmentAb() && !this.getLinkSegmentAb().isModeAllowed(mode));
    }

    default public MacroscopicLinkSegment getLinkSegmentIfLinkIsOneWayForMode(Mode mode) {
        MacroscopicLinkSegment segment = null;
        if (this.hasEdgeSegmentAb() != this.hasEdgeSegmentBa()) {
            segment = this.hasEdgeSegmentAb() ? this.getLinkSegmentAb() : this.getLinkSegmentBa();
            segment = segment.isModeAllowed(mode) ? segment : null;
        } else if (this.getLinkSegmentAb().isModeAllowed(mode) != this.getLinkSegmentBa().isModeAllowed(mode)) {
            segment = this.getLinkSegmentAb().isModeAllowed(mode) ? this.getLinkSegmentAb() : this.getLinkSegmentBa();
        }
        return segment;
    }

    @Override
    public MacroscopicLink shallowClone();

    @Override
    public MacroscopicLink deepClone();
}

