/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.network.layer;

import java.util.Collection;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.id.ManagedId;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.PredefinedModeType;

public interface NetworkLayer
extends ExternalIdAble,
ManagedId {
    public static final Class<NetworkLayer> NETWORK_LAYER_ID_CLASS = NetworkLayer.class;

    default public Class<NetworkLayer> getIdClass() {
        return NETWORK_LAYER_ID_CLASS;
    }

    @Override
    public NetworkLayer shallowClone();

    @Override
    public NetworkLayer deepClone();

    public static String createLayerLogPrefix(NetworkLayer layer) {
        return String.format("[LAYER: %s ]", layer.getXmlId());
    }

    public boolean registerSupportedMode(Mode var1);

    public boolean registerSupportedModes(Collection<Mode> var1);

    public Collection<Mode> getSupportedModes();

    public boolean supportsPredefinedMode(PredefinedModeType var1);

    public boolean isEmpty();

    public void logInfo(String var1);

    public boolean validate();

    default public boolean supports(Mode mode) {
        return this.getSupportedModes().contains(mode);
    }

    default public boolean supports(PredefinedModeType modeType) {
        return this.getSupportedModes().stream().anyMatch(m -> m.isPredefinedModeType() && m.getPredefinedModeType().equals((Object)modeType));
    }

    default public boolean hasSupportedModes() {
        return !this.getSupportedModes().isEmpty();
    }

    default public Mode getFirstSupportedMode() {
        return this.hasSupportedModes() ? this.getSupportedModes().iterator().next() : null;
    }

    public void reset();
}

