/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.network.layer;

import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.ConjugateMacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLink;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentTypes;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegments;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinks;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.network.layer.physical.Nodes;
import org.goplanit.utils.network.layer.physical.UntypedPhysicalLayer;
import org.goplanit.utils.network.virtual.ConjugateVirtualNetwork;

public interface MacroscopicNetworkLayer
extends UntypedPhysicalLayer<Node, MacroscopicLink, MacroscopicLinkSegment> {
    @Override
    public MacroscopicNetworkLayer shallowClone();

    @Override
    public MacroscopicNetworkLayer deepClone();

    public MacroscopicLinks getLinks();

    public MacroscopicLinkSegments getLinkSegments();

    public Nodes getNodes();

    public MacroscopicLinkSegmentTypes getLinkSegmentTypes();

    default public double findMaximumSpeedLimitKmH(Mode mode) {
        return this.getLinkSegmentTypes().findMaximumSpeedLimit(mode);
    }

    default public double findMaximumPaceHKm(Mode mode) {
        return 1.0 / this.findMaximumSpeedLimitKmH(mode);
    }

    public ConjugateMacroscopicNetworkLayer createConjugate(IdGroupingToken var1, ConjugateVirtualNetwork var2);
}

