/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.mode;

import java.util.Arrays;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.id.ManagedId;
import org.goplanit.utils.mode.PhysicalModeFeatures;
import org.goplanit.utils.mode.PredefinedModeType;
import org.goplanit.utils.mode.UsabilityModeFeatures;

public interface Mode
extends ExternalIdAble,
ManagedId {
    public static final Class<Mode> MODE_ID_CLASS = Mode.class;
    public static final double GLOBAL_DEFAULT_MAXIMUM_SPEED_KMH = 80.0;
    public static final double GLOBAL_DEFAULT_PCU = 1.0;
    public static final String DEFAULT_XML_ID = "1";

    public double getPcu();

    public PhysicalModeFeatures getPhysicalFeatures();

    public UsabilityModeFeatures getUseFeatures();

    public String getName();

    public double getMaximumSpeedKmH();

    default public Class<Mode> getIdClass() {
        return MODE_ID_CLASS;
    }

    default public boolean hasPhysicalFeatures() {
        return this.getPhysicalFeatures() != null;
    }

    default public boolean hasUseFeatures() {
        return this.getUseFeatures() != null;
    }

    default public boolean isPredefinedModeType() {
        return false;
    }

    default public PredefinedModeType getPredefinedModeType() {
        return PredefinedModeType.CUSTOM;
    }

    default public boolean hasName() {
        return this.getName() != null && !this.getName().isBlank();
    }

    default public boolean containsExternalId(char separator, String externalId) {
        return Arrays.stream(this.getSplitExternalId(separator)).anyMatch(e -> e.equals(Character.valueOf(separator)));
    }
}

