/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.misc;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.resource.ResourceUtils;

public class UrlUtils {
    private static final Logger LOGGER = Logger.getLogger(UrlUtils.class.getCanonicalName());
    public static final String PROTOCOL_FILE = "file";

    public static boolean isLocal(URL url) {
        try {
            String scheme = url.getProtocol();
            return !UrlUtils.hasHost(url) && PROTOCOL_FILE.equalsIgnoreCase(scheme);
        }
        catch (Exception e) {
            LOGGER.severe(String.format("Unable to verify if URL %s is local", url != null ? url.toString() : ""));
            return false;
        }
    }

    public static boolean isLocalFile(URL url) {
        return UrlUtils.isLocal(url) && new File(url.getFile()).isFile();
    }

    public static boolean isLocalDirectory(URL url) {
        return UrlUtils.isLocal(url) && new File(url.getFile()).isDirectory();
    }

    public static boolean isLocalZipFile(URL url) {
        return UrlUtils.isLocalFile(url) && url.getFile().endsWith(".zip");
    }

    public static boolean hasHost(URL url) {
        String host = url.getHost();
        return host != null && !"".equals(host);
    }

    public static URL createFrom(String path) {
        try {
            URL result = new URL(path);
            return result;
        }
        catch (Exception result) {
            try {
                return UrlUtils.createFromLocalPathOrResource(path);
            }
            catch (Exception e) {
                throw new PlanItRunTimeException("Unable to extract URL from %s", path);
            }
        }
    }

    public static URL createFromLocalPath(String path) {
        return UrlUtils.createFromLocalPath(Paths.get(path, new String[0]));
    }

    public static URL createFromLocalPath(Path path) {
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException e) {
            LOGGER.severe(String.format("Unable to create URL from Path %s", path));
            return null;
        }
    }

    public static URL createFromLocalPathOrResource(String path) {
        URL asLocalFile = UrlUtils.createFromLocalPath(path);
        if (asLocalFile != null && UrlUtils.isLocalFile(asLocalFile)) {
            return asLocalFile;
        }
        return ResourceUtils.getResourceUrl(path);
    }

    public static URL createFromLocalPathOrResource(Path path) {
        return UrlUtils.createFromLocalPathOrResource(path.toString());
    }

    public static URL appendRelativePathToURL(URL baseUrl, String relativePath) {
        try {
            URI baseUri = baseUrl.toURI();
            String relPathToAdd = StringUtils.removeInitialStringWhenPresent(relativePath, "/");
            String pathWithoutTrailingSlash = StringUtils.removeEndingStringWhenPresent(baseUri.getPath(), "/");
            String combinedRawPath = pathWithoutTrailingSlash + "/" + relPathToAdd;
            return new URI(baseUri.getScheme(), baseUri.getAuthority(), combinedRawPath, baseUri.getQuery(), baseUri.getFragment()).toURL();
        }
        catch (Exception e) {
            LOGGER.warning(String.format("Unable to append relativePath %s to base URL %s", relativePath != null ? relativePath : "", baseUrl != null ? baseUrl.toString() : ""));
            return null;
        }
    }

    public static Path asLocalPath(URL url) {
        Path localPath = null;
        try {
            localPath = Paths.get(url.toURI());
        }
        catch (Exception e) {
            LOGGER.warning(String.format("Unable to convert URL %s to local path", url != null ? url.toString() : ""));
        }
        return localPath;
    }
}

