/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.misc;

import java.util.Objects;
import java.util.function.Consumer;

public class Triple<A, B, C> {
    protected final A first;
    protected final B second;
    protected final C third;

    protected Triple(A first, B second, C third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public static <A, B, C> Triple<A, B, C> of(A valueA, B valueB, C valueC) {
        return new Triple<A, B, C>(valueA, valueB, valueC);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second, this.third);
    }

    public boolean equals(Object other) {
        if (other instanceof Triple) {
            Triple otherPair = (Triple)other;
            return (this.first == otherPair.first || this.first != null && otherPair.first != null && this.first.equals(otherPair.first)) && (this.second == otherPair.second || this.second != null && otherPair.second != null && this.second.equals(otherPair.second)) && (this.third == otherPair.third || this.third != null && otherPair.third != null && this.third.equals(otherPair.third));
        }
        return false;
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ", " + this.third + ")";
    }

    public Triple<A, B, C> copy() {
        return Triple.of(this.first, this.second, this.third);
    }

    public A first() {
        return this.first;
    }

    public B second() {
        return this.second;
    }

    public C third() {
        return this.third;
    }

    public boolean anyIsNotNull() {
        return this.first() != null || this.second() != null || this.third() != null;
    }

    public boolean allNotNull() {
        return this.first() != null && this.second() != null && this.third() != null;
    }

    public boolean anyIsNull() {
        return !this.allNotNull();
    }

    public Object getEarliestNonNull() {
        if (this.first() != null) {
            return this.first();
        }
        if (this.secondNotNull()) {
            return this.second();
        }
        return this.third();
    }

    public <T> void both(Consumer<T> tripleEntryConsumer) {
        tripleEntryConsumer.accept(this.first);
        tripleEntryConsumer.accept(this.second);
        tripleEntryConsumer.accept(this.third);
    }

    public boolean firstNotNull() {
        return this.first() != null;
    }

    public boolean secondNotNull() {
        return this.second() != null;
    }

    public boolean thirdNotNull() {
        return this.third() != null;
    }

    public boolean different() {
        return !this.first().equals(this.second()) || !this.second().equals(this.third());
    }

    public boolean allNull() {
        return !this.firstNotNull() && !this.secondNotNull() && !this.thirdNotNull();
    }
}

