/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.misc;

import java.nio.charset.Charset;

public class StringUtils {
    private static String createPaddingFormatString(int numPadding) {
        StringBuilder sb = new StringBuilder("%0");
        sb.append(numPadding);
        sb.append("d");
        return sb.toString();
    }

    public static String removeBOM(String value) {
        return value.replace("\ufeff", "");
    }

    public static String[] splitByAnythingExceptAlphaNumeric(String toSplit) {
        return toSplit.split("[^a-zA-Z0-9]");
    }

    public static boolean isNullOrBlank(String string) {
        return string == null || string.isBlank();
    }

    public static String removeInitialStringWhenPresent(String theString, String initialString) {
        return theString.startsWith(initialString) ? theString.substring(initialString.length()) : theString;
    }

    public static String removeEndingStringWhenPresent(String theString, String endString) {
        return theString.endsWith(endString) ? theString.substring(0, theString.length() - endString.length()) : theString;
    }

    public static String zeroPaddedStringOf(int value, int numPadding) {
        String paddingFormatString = StringUtils.createPaddingFormatString(numPadding);
        return String.format(paddingFormatString, value);
    }

    public static String printBytes(String str, Charset encoding) {
        byte[] bytes = str.getBytes(encoding);
        String output = str + "= byte[";
        for (int i = 0; i < bytes.length; ++i) {
            output = output + Byte.toString(bytes[i]);
            if (i >= bytes.length - 1) continue;
            output = output + ", ";
        }
        output = output + "]";
        return output;
    }

    public static String printChars(String str) {
        char[] chars = str.toCharArray();
        String output = str + "= char[";
        for (int i = 0; i < chars.length; ++i) {
            output = output + String.valueOf(chars[i]);
            if (i >= chars.length - 1) continue;
            output = output + ", ";
        }
        output = output + "]";
        return output;
    }
}

