/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.misc;

import java.util.Objects;
import java.util.function.Consumer;

public class Quadruple<A, B, C, D> {
    protected final A first;
    protected final B second;
    protected final C third;
    protected final D fourth;

    protected Quadruple(A first, B second, C third, D fourth) {
        this.first = first;
        this.second = second;
        this.third = third;
        this.fourth = fourth;
    }

    public static <A, B, C, D> Quadruple<A, B, C, D> of(A valueA, B valueB, C valueC, D valueD) {
        return new Quadruple<A, B, C, D>(valueA, valueB, valueC, valueD);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second, this.third, this.fourth);
    }

    public boolean equals(Object other) {
        if (other instanceof Quadruple) {
            Quadruple otherQ = (Quadruple)other;
            return (this.first == otherQ.first || this.first != null && otherQ.first != null && this.first.equals(otherQ.first)) && (this.second == otherQ.second || this.second != null && otherQ.second != null && this.second.equals(otherQ.second)) && (this.third == otherQ.third || this.third != null && otherQ.third != null && this.third.equals(otherQ.third)) && (this.fourth == otherQ.fourth || this.fourth != null && otherQ.fourth != null && this.fourth.equals(otherQ.fourth));
        }
        return false;
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ", " + this.third + ", " + this.fourth + ")";
    }

    public Quadruple<A, B, C, D> copy() {
        return Quadruple.of(this.first, this.second, this.third, this.fourth);
    }

    public A first() {
        return this.first;
    }

    public B second() {
        return this.second;
    }

    public C third() {
        return this.third;
    }

    public D fourth() {
        return this.fourth;
    }

    public boolean anyIsNotNull() {
        return this.first() != null || this.second() != null || this.third() != null || this.fourth() != null;
    }

    public boolean allNotNull() {
        return this.first() != null && this.second() != null && this.third() != null && this.fourth() != null;
    }

    public boolean anyIsNull() {
        return !this.allNotNull();
    }

    public <T> void all(Consumer<T> consumer) {
        consumer.accept(this.first);
        consumer.accept(this.second);
        consumer.accept(this.third);
        consumer.accept(this.fourth);
    }
}

