/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.misc;

import java.util.Objects;
import java.util.function.Consumer;

public class Pair<A, B> {
    protected final A first;
    protected final B second;

    protected Pair(A first, B second) {
        this.first = first;
        this.second = second;
    }

    public static <A, B> Pair<A, B> of(A valueA, B valueB) {
        return new Pair<A, B>(valueA, valueB);
    }

    public static <A, B> Pair<A, B> empty() {
        return Pair.of(null, null);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public boolean equals(Object other) {
        if (other instanceof Pair) {
            Pair otherPair = (Pair)other;
            return (this.first == otherPair.first || this.first != null && otherPair.first != null && this.first.equals(otherPair.first)) && (this.second == otherPair.second || this.second != null && otherPair.second != null && this.second.equals(otherPair.second));
        }
        return false;
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ")";
    }

    public Pair<A, B> copy() {
        return Pair.of(this.first, this.second);
    }

    public A first() {
        return this.first;
    }

    public B second() {
        return this.second;
    }

    public boolean anyIsNotNull() {
        return this.first() != null || this.second() != null;
    }

    public boolean bothNotNull() {
        return this.first() != null && this.second() != null;
    }

    public boolean anyIsNull() {
        return !this.bothNotNull();
    }

    public boolean isExactlyOneNonNull() {
        return this.anyIsNotNull() && !this.bothNotNull();
    }

    public Object getEarliestNonNull() {
        if (this.first() != null) {
            return this.first();
        }
        return this.second();
    }

    public <T> void both(Consumer<T> pairEntryConsumer) {
        pairEntryConsumer.accept(this.first);
        pairEntryConsumer.accept(this.second);
    }

    public boolean firstNotNull() {
        return this.first() != null;
    }

    public boolean secondNotNull() {
        return this.second() != null;
    }

    public boolean different() {
        return !this.first().equals(this.second());
    }

    public boolean bothNull() {
        return this.first() == null && this.second() == null;
    }
}

