/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.misc;

import java.util.function.Predicate;
import java.util.logging.Logger;
import org.goplanit.utils.time.TimePeriod;

public class LoggingUtils {
    public static String surroundwithBrackets(String message) {
        return String.format("[%s] ", message);
    }

    public static String runIdPrefix(long runId) {
        return LoggingUtils.surroundwithBrackets(String.format("run id: %d", runId));
    }

    public static String projectPrefix(long projectId) {
        return LoggingUtils.surroundwithBrackets(String.format("project id: %d", projectId));
    }

    public static String networkPrefix(long networkId) {
        return LoggingUtils.surroundwithBrackets(String.format("network id: %d", networkId));
    }

    public static String networkLayerPrefix(long layerId) {
        return LoggingUtils.surroundwithBrackets(String.format("n-layer id: %d", layerId));
    }

    public static String zoningPrefix(long zoningId) {
        return LoggingUtils.surroundwithBrackets(String.format("zoning id: %d", zoningId));
    }

    public static String demandsPrefix(long demandsId) {
        return LoggingUtils.surroundwithBrackets(String.format("demands id: %d", demandsId));
    }

    public static String serviceNetworkPrefix(long serviceNetworkId) {
        return LoggingUtils.surroundwithBrackets(String.format("services network id: %d", serviceNetworkId));
    }

    public static String serviceNetworkLayerPrefix(long serviceNetworkLayerId) {
        return LoggingUtils.surroundwithBrackets(String.format("s_layer id: %d", serviceNetworkLayerId));
    }

    public static String routedServicesPrefix(long routedServicesId) {
        return LoggingUtils.surroundwithBrackets(String.format("routed services id: %d", routedServicesId));
    }

    public static String routedServiceLayerPrefix(long routedServiceLayerId) {
        return LoggingUtils.surroundwithBrackets(String.format("rs_layer id: %d", routedServiceLayerId));
    }

    public static String odPathSetsPrefix(long odPathSetsId) {
        return LoggingUtils.surroundwithBrackets(String.format("od path sets id: %d", odPathSetsId));
    }

    public static String outputFormatterPrefix(long outputFormatterId) {
        return LoggingUtils.surroundwithBrackets(String.format("output formatter id: %d", outputFormatterId));
    }

    public static String timePeriodPrefix(TimePeriod timePeriod) {
        Object timePeriodReference = timePeriod.hasExternalId() ? "external id: " + timePeriod.getExternalId() : (timePeriod.hasXmlId() ? "xml id: " + timePeriod.getXmlId() : "");
        return LoggingUtils.surroundwithBrackets(String.format("time period: %s (id %d)", timePeriodReference, timePeriod.getId()));
    }

    public static String iterationPrefix(int iterationIndex) {
        return LoggingUtils.surroundwithBrackets(String.format("iteration: %d", iterationIndex));
    }

    public static String logActiveStateByClassName(Object item, boolean activate) {
        return (activate ? "activated: " : "deactivated:") + item.getClass().getSimpleName();
    }

    public static String getClassNameWithBrackets(Object item) {
        return LoggingUtils.surroundwithBrackets(item.getClass().getSimpleName());
    }

    public static String surround(String theString, char c, int repeat) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < repeat; ++i) {
            sb.append(c);
        }
        sb.append(" ").append(theString).append(" ");
        for (i = 0; i < repeat; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static void LogSevereIfNull(Object object, Logger logger, String message, Object ... arguments) {
        if (object == null) {
            logger.severe(String.format(message, arguments));
        }
    }

    public static void LogFineIfNull(Object object, Logger logger, String message, Object ... arguments) {
        if (object == null) {
            logger.fine(String.format(message, arguments));
        }
    }

    public static <T> void logWarningIf(Logger logger, String message, T testObject, Predicate<T> predicate) {
        if (predicate.test(testObject)) {
            logger.warning(message);
        }
    }
}

