/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.goplanit.utils.misc.IterableUtils;

public class IteratorUtils {
    public static <T> Iterable<T> toIterable(Iterator<T> iterator) {
        return () -> iterator;
    }

    public static <T, K> Map<K, T> toMap(Iterator<T> iterator, Function<T, K> getKey, Map<K, T> mapToFill) {
        Object entry = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            mapToFill.put(getKey.apply(entry), entry);
        }
        return mapToFill;
    }

    public static <T> List<T> toList(Iterator<T> iterator) {
        ArrayList<T> theList = new ArrayList<T>();
        while (iterator.hasNext()) {
            theList.add(iterator.next());
        }
        return theList;
    }

    public static <T> Stream<T> asStream(Iterator<T> iterator) {
        return IterableUtils.asStream(IteratorUtils.toIterable(iterator));
    }
}

