/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class IterableUtils {
    public static <T> Stream<T> asStream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> Iterable<T> toIterable(Iterator<T> iterator) {
        return () -> iterator;
    }

    public static <T> long sizeOfUsingStream(Iterable<T> iterable) {
        return (int)StreamSupport.stream(iterable.spliterator(), false).count();
    }

    public static <T> long sizeOfUsingLoop(Iterable<T> iterable) {
        long count = 0L;
        for (T entry : iterable) {
            ++count;
        }
        return count;
    }

    public static <T, K> Map<K, T> toMap(Iterable<T> iterable, Function<T, K> getKey, Map<K, T> mapToFill) {
        for (T entry : iterable) {
            mapToFill.put(getKey.apply(entry), entry);
        }
        return mapToFill;
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        return IterableUtils.toTypeCastList(iterable);
    }

    public static <U extends T, T> List<U> toTypeCastList(Iterable<T> iterable) {
        ArrayList<T> theList = new ArrayList<T>();
        for (T entry : iterable) {
            theList.add(entry);
        }
        return theList;
    }

    public static boolean nullOrEmpty(Iterable<?> iterable) {
        if (iterable == null) {
            return true;
        }
        Iterator<?> iter = iterable.iterator();
        if (iter == null) {
            return true;
        }
        return !iter.hasNext();
    }
}

