/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.misc.UrlUtils;
import org.xml.sax.InputSource;

public class FileUtils {
    private static final Logger LOGGER = Logger.getLogger(FileUtils.class.getCanonicalName());
    public static final String DOT = ".";
    public static final String ZIP = "zip";

    public static String getExtension(File file) {
        String fileName = file.getName();
        if (fileName.lastIndexOf(DOT) != -1 && fileName.lastIndexOf(DOT) != 0) {
            return fileName.substring(fileName.lastIndexOf(DOT) + 1);
        }
        return "";
    }

    public static File[] getFilesWithExtensionFromDir(String pathToDir, final String fileExtension) {
        PlanItRunTimeException.throwIf(StringUtils.isNullOrBlank(pathToDir), String.format("Path directory is null or blank when collecting files", new Object[0]), new Object[0]);
        PlanItRunTimeException.throwIf(StringUtils.isNullOrBlank(fileExtension), String.format("File extension to use is null or blank when collecting files from directory", new Object[0]), new Object[0]);
        File directoryPath = new File(pathToDir);
        PlanItRunTimeException.throwIf(!directoryPath.isDirectory(), String.format("%s is not a valid directory", directoryPath), new Object[0]);
        FilenameFilter fileExtensionFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String lowercaseName = name.toLowerCase();
                return lowercaseName.endsWith(fileExtension);
            }
        };
        return directoryPath.listFiles(fileExtensionFilter);
    }

    public static String getFileNameWithoutExtension(String fileName) {
        if (fileName != null && fileName.contains(DOT)) {
            return fileName.substring(0, fileName.lastIndexOf(46));
        }
        return fileName;
    }

    public static void callForEachFileIn(String pathToDir, Consumer<File> callBack) {
        if (pathToDir == null) {
            return;
        }
        if (callBack == null) {
            LOGGER.warning(String.format("No callback provided for any file in %s", pathToDir));
        }
        File[] filesInDir = new File(pathToDir).listFiles();
        for (int index = 0; index < filesInDir.length; ++index) {
            callBack.accept(filesInDir[index]);
        }
    }

    public static File create(URL url) {
        if (UrlUtils.isLocal(url)) {
            try {
                return new File(url.toURI());
            }
            catch (URISyntaxException e) {
                LOGGER.warning(String.format("Unable to convert URL %s to file", url.toString()));
            }
        }
        return null;
    }

    public static boolean deleteDirectory(File directoryToDelete) {
        if (!directoryToDelete.isDirectory()) {
            return false;
        }
        File[] filesInDir = directoryToDelete.listFiles();
        if (filesInDir != null) {
            for (File file : filesInDir) {
                if (file.isDirectory()) {
                    FileUtils.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        return directoryToDelete.delete();
    }

    public static InputSource getFileContentAsInputSource(String filePath, String charSetEncoding) throws FileNotFoundException, UnsupportedEncodingException {
        File file = new File(filePath);
        FileInputStream inputStream = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, charSetEncoding);
        InputSource is = new InputSource(reader);
        is.setEncoding(charSetEncoding);
        return is;
    }

    public static String parseFileContentAsString(String filePath, String charSetEncoding) throws IOException {
        int c;
        InputSource is = FileUtils.getFileContentAsInputSource(filePath, charSetEncoding);
        Reader r = is.getCharacterStream();
        StringBuilder stringBuilder = new StringBuilder();
        while ((c = r.read()) > -1) {
            stringBuilder.appendCodePoint(c);
        }
        return stringBuilder.toString();
    }

    public static String parseUtf8FileContentAsString(String filePath) throws IOException {
        return FileUtils.parseFileContentAsString(filePath, "UTF8");
    }
}

