/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.misc;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.wrapper.MapWrapper;
import org.goplanit.utils.wrapper.MapWrapperImpl;

public class CustomIndexTracker {
    private static final Logger LOGGER = Logger.getLogger(CustomIndexTracker.class.getCanonicalName());
    protected final Map<Class<?>, MapWrapper<?, ?>> entitiyByIndexTracker = new HashMap();

    public <V> void register(V obj) {
        this.register(obj.getClass(), obj);
    }

    public <U, V> void register(Class<U> theClazz, V obj) {
        MapWrapper<?, ?> mapWrapper = this.entitiyByIndexTracker.get(theClazz);
        if (mapWrapper == null) {
            throw new PlanItRunTimeException("No source id container registered for PLANit entity of type %s, unable to register, perhaps consider registering via its superclass explicitly", obj.getClass().getName());
        }
        Object old = mapWrapper.register(obj);
        if (old != null) {
            throw new PlanItRunTimeException("PLANit entity of type %s already registered by its source id %s, unable to register", obj.getClass().getName(), mapWrapper.getKeyByValue(old).toString());
        }
    }

    public <K, V> void initialiseEntityContainer(Class<V> clazz, Function<V, K> valueToKey) {
        if (this.entitiyByIndexTracker.containsKey(clazz)) {
            LOGGER.warning(String.format("Unable to register PLANit entity tracker for %s, already present", clazz.getName()));
        }
        this.entitiyByIndexTracker.put(clazz, new MapWrapperImpl(new HashMap(), valueToKey));
    }

    public <K, V> void initialiseEntityContainer(Class<V> clazz, Function<V, K> valueToKey, Iterable<V> addToSourceIdMap) {
        this.initialiseEntityContainer(clazz, valueToKey);
        this.getEntityContainer(clazz).addAll(addToSourceIdMap);
    }

    public <V> MapWrapper<?, V> getEntityContainer(Class<V> clazz) {
        return this.entitiyByIndexTracker.get(clazz);
    }

    public <V, K> V get(Class<V> clazz, K key) {
        return (V)this.entitiyByIndexTracker.get(clazz).get(key);
    }

    public void reset() {
        this.entitiyByIndexTracker.clear();
    }
}

