/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.math;

import java.text.DecimalFormat;

public class Precision {
    public static final double EPSILON_0 = 0.0;
    public static final double EPSILON_18 = 1.0E-18;
    public static final double EPSILON_15 = 1.0E-15;
    public static final double EPSILON_12 = 1.0E-12;
    public static final double EPSILON_9 = 1.0E-9;
    public static final double EPSILON_6 = 1.0E-6;
    public static final double EPSILON_3 = 0.001;
    public static final DecimalFormat DEFAULT_DECIMAL_FORMAT = (DecimalFormat)DecimalFormat.getInstance();

    public static boolean equal(double d1, double d2, double epsilon) {
        return !Precision.smaller(d1, d2, epsilon) && !Precision.greater(d1, d2, epsilon);
    }

    public static boolean equal(double d1, double d2) {
        return Precision.equal(d1, d2, 1.0E-6);
    }

    public static boolean smallerEqual(double d1, double d2, double epsilon) {
        return d1 <= d2 + epsilon;
    }

    public static boolean smaller(double d1, double d2) {
        return Precision.smaller(d1, d2, 1.0E-6);
    }

    public static boolean smaller(double d1, double d2, double epsilon) {
        return d1 + epsilon < d2;
    }

    public static boolean smallerEqual(double d1, double d2) {
        return Precision.smallerEqual(d1, d2, 1.0E-6);
    }

    public static boolean greaterEqual(double d1, double d2, double epsilon) {
        return d1 >= d2 - epsilon;
    }

    public static boolean greaterEqual(double d1, double d2) {
        return Precision.greaterEqual(d1, d2, 1.0E-6);
    }

    public static boolean greater(double d1, double d2, double epsilon) {
        return d1 - epsilon > d2;
    }

    public static boolean greater(double d1, double d2) {
        return Precision.greater(d1, d2, 1.0E-6);
    }

    public static boolean positive(double d1) {
        return Precision.greater(d1, 0.0, 1.0E-6);
    }

    public static boolean positive(double d1, double epsilon) {
        return Precision.greater(d1, 0.0, epsilon);
    }

    public static boolean negative(double d1) {
        return Precision.smaller(d1, 0.0, 1.0E-6);
    }

    public static boolean nonZero(double d1) {
        return Precision.positive(d1) || Precision.negative(d1);
    }

    public static boolean notEqual(double d1, double d2) {
        return !Precision.equal(d1, d2);
    }

    public static boolean notEqual(double d1, double d2, double epsilon) {
        return !Precision.equal(d1, d2, epsilon);
    }

    static {
        DEFAULT_DECIMAL_FORMAT.setMaximumFractionDigits(8);
        DEFAULT_DECIMAL_FORMAT.setMinimumFractionDigits(2);
        DEFAULT_DECIMAL_FORMAT.setGroupingUsed(false);
    }
}

