/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.id;

import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.ManagedId;
import org.goplanit.utils.id.ManagedIdEntities;
import org.goplanit.utils.wrapper.LongMapWrapperImpl;

public abstract class ManagedIdEntitiesImpl<E extends ManagedId>
extends LongMapWrapperImpl<E>
implements ManagedIdEntities<E> {
    protected final Class<? extends ManagedId> managedIdClass;

    protected ManagedIdEntitiesImpl(Function<E, Long> valueToKey, Class<? extends ManagedId> managedIdClass) {
        super(new TreeMap(), valueToKey);
        this.managedIdClass = managedIdClass;
    }

    protected ManagedIdEntitiesImpl(Function<E, Long> valueToKey) {
        super(new TreeMap(), valueToKey);
        this.managedIdClass = null;
    }

    protected ManagedIdEntitiesImpl(ManagedIdEntitiesImpl<E> other, boolean deepCopy, BiConsumer<E, E> mapper) {
        super(other);
        this.managedIdClass = other.managedIdClass;
        if (deepCopy) {
            this.clear();
            other.forEach(v -> {
                ManagedId copy = (ManagedId)v.deepClone();
                this.register(copy);
                if (mapper != null) {
                    mapper.accept(v, copy);
                }
            });
        }
    }

    protected void updateIdMapping() {
        Map updatedMap = ManagedIdEntitiesImpl.createEmptyInstance(this.getMap());
        this.getMap().forEach((? super K oldId, ? super V entity) -> updatedMap.put((Long)this.getValueToKey().apply(entity), entity));
        this.getMap().clear();
        this.setMap(updatedMap);
    }

    @Override
    public Class<? extends ManagedId> getManagedIdClass() {
        return this.managedIdClass;
    }

    @Override
    public void recreateIds(boolean resetManagedIdClass) {
        if (resetManagedIdClass && this.managedIdClass != null) {
            IdGenerator.reset(this.getFactory().getIdGroupingToken(), this.getManagedIdClass());
        }
        if (!this.isEmpty()) {
            for (ManagedId entity : this) {
                entity.recreateManagedIds(this.getFactory().getIdGroupingToken());
            }
            this.updateIdMapping();
        }
    }

    @Override
    public void reset() {
        for (ManagedId entry : this) {
            entry.resetChildManagedIdEntities();
        }
        this.clear();
        if (this.managedIdClass != null) {
            IdGenerator.reset(this.getFactory().getIdGroupingToken(), this.getManagedIdClass());
        }
    }

    @Override
    public abstract ManagedIdEntitiesImpl<E> shallowClone();

    @Override
    public abstract ManagedIdEntitiesImpl<E> deepClone();

    @Override
    public abstract ManagedIdEntitiesImpl<E> deepCloneWithMapping(BiConsumer<E, E> var1);
}

