/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.id;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.ManagedId;
import org.goplanit.utils.id.ManagedIdEntityFactory;
import org.goplanit.utils.wrapper.LongMapWrapper;

public interface ManagedIdEntities<E extends ManagedId>
extends LongMapWrapper<E> {
    public ManagedIdEntityFactory<E> getFactory();

    public Class<? extends ManagedId> getManagedIdClass();

    public void recreateIds(boolean var1);

    public ManagedIdEntities<E> shallowClone();

    public ManagedIdEntities<E> deepClone();

    public ManagedIdEntities<E> deepCloneWithMapping(BiConsumer<E, E> var1);

    @Override
    default public boolean containsKey(long id) {
        return this.get(id) != null;
    }

    default public void recreateIds() {
        this.recreateIds(true);
    }

    default public void reset() {
        for (ManagedId entry : this) {
            entry.resetChildManagedIdEntities();
        }
        this.clear();
        IdGenerator.reset(this.getFactory().getIdGroupingToken(), this.getManagedIdClass());
    }

    default public <K> Map<K, List<E>> groupBy(Function<? super E, ? extends K> classifier) {
        return this.stream().collect(Collectors.groupingBy(classifier));
    }

    default public <T extends Comparable, F extends E> Stream<F> streamSortedBy(Function<? super E, T> sortFunction) {
        return this.stream().sorted(Comparator.comparing(e -> (Comparable)sortFunction.apply((Object)e)));
    }
}

