/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.id;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.LocalIdGenerator;

public final class IdGenerator {
    private static final Logger LOGGER = Logger.getLogger(IdGenerator.class.getCanonicalName());
    private static Map<IdGroupingToken, LocalIdGenerator> idGroups = new HashMap<IdGroupingToken, LocalIdGenerator>();

    protected static LocalIdGenerator createIdGeneratorForParent(IdGroupingToken token) {
        LocalIdGenerator idGenerator = new LocalIdGenerator();
        idGroups.put(token, idGenerator);
        LOGGER.fine("created id group for" + token.toString());
        return idGroups.get(token);
    }

    public static long generateId(IdGroupingToken token, Class<? extends Object> theClass) {
        LocalIdGenerator idGeneratorForGroup = null;
        idGeneratorForGroup = !idGroups.containsKey(token) ? IdGenerator.createIdGeneratorForParent(token) : idGroups.get(token);
        return idGeneratorForGroup.generateId(theClass);
    }

    public static void reset() {
        idGroups.clear();
    }

    public static void reset(IdGroupingToken groupId) {
        if (idGroups.containsKey(groupId)) {
            idGroups.get(groupId).reset();
        }
    }

    public static void reset(IdGroupingToken groupId, Class<? extends Object> theClass) {
        if (idGroups.containsKey(groupId)) {
            idGroups.get(groupId).reset(theClass);
        }
    }

    public static void resetTo(IdGroupingToken groupId, Class<? extends Object> theClass, long offset) {
        if (idGroups.containsKey(groupId)) {
            idGroups.get(groupId).resetTo(theClass, offset);
        }
    }

    public static IdGroupingToken createIdGroupingToken(String groupDescription) {
        return IdGroupingToken.create(groupDescription);
    }

    public static IdGroupingToken createIdGroupingToken(Object groupOwner, long groupOwnerId) {
        return new IdGroupingToken(groupOwner.getClass().getSimpleName() + "-" + Long.toString(groupOwnerId));
    }

    public static long getLatestIdForToken(IdGroupingToken token, Class<? extends Object> theClass) {
        LocalIdGenerator idGeneratorForGroup;
        if (idGroups.containsKey(token) && (idGeneratorForGroup = idGroups.get(token)) != null) {
            return idGeneratorForGroup.getLatestGeneratedId(theClass);
        }
        return -1L;
    }
}

