/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.id;

import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.id.IdAble;
import org.goplanit.utils.misc.CharacterUtils;
import org.goplanit.utils.misc.StringUtils;

public interface ExternalIdAble
extends IdAble {
    public String getExternalId();

    public void setExternalId(String var1);

    public String getXmlId();

    public void setXmlId(String var1);

    default public void setXmlId(long xmlId) {
        this.setXmlId(String.valueOf(xmlId));
    }

    default public boolean hasXmlId() {
        return this.getXmlId() != null;
    }

    default public boolean hasExternalId() {
        return this.getExternalId() != null;
    }

    default public void appendExternalId(String appendWith) {
        this.appendExternalId(appendWith, CharacterUtils.COMMA);
    }

    default public String[] getSplitExternalId() {
        return this.getSplitExternalId(CharacterUtils.COMMA.charValue());
    }

    default public String[] getSplitExternalId(char separator) {
        return this.getExternalId().split(String.valueOf(separator));
    }

    default public void appendExternalId(String appendWith, Character separator) {
        PlanItRunTimeException.throwIfNull(separator, "Separator null");
        if (StringUtils.isNullOrBlank(appendWith)) {
            return;
        }
        if (!this.hasExternalId()) {
            this.setExternalId(appendWith);
            return;
        }
        this.setExternalId(String.join((CharSequence)separator.toString(), this.getExternalId(), appendWith));
    }

    default public String getIdsAsString() {
        return String.format("id: %d, xmlId: %s, extId: %s", this.getId(), this.getXmlId(), this.getExternalId());
    }
}

